/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.ClassLoaderUtils;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Transform
extends SignatureElementProxy {
    private static Log log = LogFactory.getLog(Transform.class.getName());
    private static boolean alreadyInitialized = false;
    private static HashMap transformClassHash = null;
    private static HashMap transformSpiHash = new HashMap();
    private TransformSpi transformSpi = null;

    public Transform(Document document, String string, NodeList nodeList) throws InvalidTransformException {
        super(document);
        this._constructionElement.setAttributeNS(null, "Algorithm", string);
        this.transformSpi = Transform.getTransformSpi(string);
        if (this.transformSpi == null) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
        if (log.isDebugEnabled()) {
            log.debug("Create URI \"" + string + "\" class \"" + this.transformSpi.getClass() + "\"");
            log.debug("The NodeList is " + nodeList);
        }
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this._constructionElement.appendChild(nodeList.item(i).cloneNode(true));
            }
        }
    }

    public Transform(Element element, String string) throws InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, string);
        String string2 = element.getAttributeNS(null, "Algorithm");
        if (string2 == null || string2.length() == 0) {
            Object[] objectArray = new Object[]{"Algorithm", "Transform"};
            throw new TransformationException("xml.WrongContent", objectArray);
        }
        this.transformSpi = Transform.getTransformSpi(string2);
        if (this.transformSpi == null) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
    }

    public static Transform getInstance(Document document, String string) throws InvalidTransformException {
        return Transform.getInstance(document, string, (NodeList)null);
    }

    public static Transform getInstance(Document document, String string, Element element) throws InvalidTransformException {
        HelperNodeList helperNodeList = null;
        if (element != null) {
            helperNodeList = new HelperNodeList();
            XMLUtils.addReturnToElement(document, helperNodeList);
            helperNodeList.appendChild(element);
            XMLUtils.addReturnToElement(document, helperNodeList);
        }
        return Transform.getInstance(document, string, helperNodeList);
    }

    public static Transform getInstance(Document document, String string, NodeList nodeList) throws InvalidTransformException {
        return new Transform(document, string, nodeList);
    }

    public static void init() {
        if (!alreadyInitialized) {
            transformClassHash = new HashMap(10);
            alreadyInitialized = true;
        }
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException {
        Class clazz = Transform.getImplementingClass(string);
        if (clazz != null) {
            Object[] objectArray = new Object[]{string, clazz};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        try {
            transformClassHash.put(string, ClassLoaderUtils.loadClass(string2, Transform.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput xMLSignatureInput2 = null;
        try {
            xMLSignatureInput2 = this.transformSpi.enginePerformTransform(xMLSignatureInput, this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, sAXException);
        }
        return xMLSignatureInput2;
    }

    public XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput xMLSignatureInput2 = null;
        try {
            xMLSignatureInput2 = this.transformSpi.enginePerformTransform(xMLSignatureInput, outputStream, this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, sAXException);
        }
        return xMLSignatureInput2;
    }

    private static Class getImplementingClass(String string) {
        return (Class)transformClassHash.get(string);
    }

    private static TransformSpi getTransformSpi(String string) throws InvalidTransformException {
        try {
            Object v = transformSpiHash.get(string);
            if (v != null) {
                return (TransformSpi)v;
            }
            Class clazz = (Class)transformClassHash.get(string);
            if (clazz != null) {
                TransformSpi transformSpi = (TransformSpi)clazz.newInstance();
                transformSpiHash.put(string, transformSpi);
                return transformSpi;
            }
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, illegalAccessException);
        }
        return null;
    }

    public String getBaseLocalName() {
        return "Transform";
    }
}

