/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.signature.XMLSignatureException;

public class SignerOutputStream
extends ByteArrayOutputStream {
    final SignatureAlgorithm sa;
    static Log log = LogFactory.getLog(SignerOutputStream.class.getName());

    public SignerOutputStream(SignatureAlgorithm signatureAlgorithm) {
        this.sa = signatureAlgorithm;
    }

    public void write(byte[] byArray) {
        try {
            this.sa.update(byArray);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }

    public void write(int n) {
        try {
            this.sa.update((byte)n);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        if (log.isDebugEnabled()) {
            log.debug("Canonicalized SignedInfo:");
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int i = n; i < n + n2; ++i) {
                stringBuffer.append((char)byArray[i]);
            }
            log.debug(stringBuffer.toString());
        }
        try {
            this.sa.update(byArray, n, n2);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }
}

