/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.util.Timer;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.saml2.metadata.provider.AbstractReloadingMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBackedMetadataProvider
extends AbstractReloadingMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(ResourceBackedMetadataProvider.class);
    private Resource metadataResource;
    private DateTime lastResourceUpdate;

    public ResourceBackedMetadataProvider(Resource resource, Timer timer, long maxMetadataCacheDuration) throws MetadataProviderException {
        super(timer);
        try {
            if (!resource.exists()) {
                throw new MetadataProviderException("Resource " + resource.getLocation() + " does not exist.");
            }
            this.metadataResource = resource;
        }
        catch (ResourceException e) {
            throw new MetadataProviderException("Unable to read resource", e);
        }
    }

    public ResourceBackedMetadataProvider(Timer timer, Resource resource) throws MetadataProviderException {
        super(timer);
        try {
            if (!resource.exists()) {
                throw new MetadataProviderException("Resource " + resource.getLocation() + " does not exist.");
            }
            this.metadataResource = resource;
        }
        catch (ResourceException e) {
            throw new MetadataProviderException("Unable to read resource", e);
        }
    }

    public boolean maintainExpiredMetadata() {
        return !this.requireValidMetadata();
    }

    public void setMaintainExpiredMetadata(boolean maintain) {
        this.setRequireValidMetadata(!maintain);
    }

    protected String getMetadataIdentifier() {
        return this.metadataResource.getLocation();
    }

    protected byte[] fetchMetadata() throws MetadataProviderException {
        try {
            DateTime metadataUpdateTime = this.metadataResource.getLastModifiedTime();
            this.log.debug("resource {} was last modified {}", (Object)this.metadataResource.getLocation(), (Object)metadataUpdateTime);
            if (this.getLastRefresh() == null || metadataUpdateTime.isAfter((ReadableInstant)this.getLastRefresh())) {
                return this.inputstreamToByteArray(this.metadataResource.getInputStream());
            }
            return null;
        }
        catch (ResourceException e) {
            String errorMsg = "Unable to read metadata file";
            this.log.error(errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, e);
        }
    }
}

