/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.provider;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.provider.HTTPGetListenerServlet;
import org.apache.tuscany.sca.binding.http.provider.HTTPServiceListenerServlet;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class HTTPServiceBindingProvider
implements ServiceBindingProvider {
    private RuntimeComponentService service;
    private HTTPBinding binding;
    private MessageFactory messageFactory;
    private ServletHost servletHost;
    private String servletMapping;

    public HTTPServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, HTTPBinding binding, MessageFactory messageFactory, ServletHost servletHost) {
        this.service = service;
        this.binding = binding;
        this.messageFactory = messageFactory;
        this.servletHost = servletHost;
    }

    public void start() {
        RuntimeComponentService componentService = this.service;
        RuntimeWire wire = componentService.getRuntimeWire((Binding)this.binding);
        Object servlet = null;
        for (InvocationChain invocationChain : wire.getInvocationChains()) {
            Operation operation = invocationChain.getTargetOperation();
            String operationName = operation.getName();
            if (operationName.equals("get")) {
                Invoker getInvoker = invocationChain.getHeadInvoker();
                servlet = new HTTPGetListenerServlet(getInvoker, this.messageFactory);
                break;
            }
            if (!operationName.equals("service")) continue;
            Invoker serviceInvoker = invocationChain.getHeadInvoker();
            servlet = new HTTPServiceListenerServlet(serviceInvoker, this.messageFactory);
            break;
        }
        if (servlet == null) {
            throw new IllegalStateException("No get or service method found on the service");
        }
        this.servletMapping = this.binding.getURI();
        if (!this.servletMapping.endsWith("/")) {
            this.servletMapping = this.servletMapping + "/";
        }
        if (!this.servletMapping.endsWith("*")) {
            this.servletMapping = this.servletMapping + "*";
        }
        this.servletHost.addServletMapping(this.servletMapping, servlet);
        this.binding.setURI(this.servletHost.getURLMapping(this.binding.getURI()).toString());
    }

    public void stop() {
        this.servletHost.removeServletMapping(this.servletMapping);
    }

    public InterfaceContract getBindingInterfaceContract() {
        return null;
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }
}

