/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.http.HTTPCacheContext;
import org.apache.tuscany.sca.binding.http.util.HTTPHeadersParser;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;

public class HTTPBindingListenerServlet
extends HttpServlet {
    private static final long serialVersionUID = 2865466417329430610L;
    private static final QName AUTEHTICATION_INTENT = new QName("http://www.osoa.org/xmlns/sca/1.0", "authentication");
    private transient Binding binding;
    private transient boolean requiresAuthentication = false;
    private transient BasicAuthenticationPolicy basicAuthenticationPolicy = null;
    private MessageFactory messageFactory;
    private Invoker getInvoker;
    private Invoker conditionalGetInvoker;
    private Invoker putInvoker;
    private Invoker conditionalPutInvoker;
    private Invoker postInvoker;
    private Invoker conditionalPostInvoker;
    private Invoker deleteInvoker;
    private Invoker conditionalDeleteInvoker;

    public HTTPBindingListenerServlet(Binding binding, MessageFactory messageFactory) {
        this.binding = binding;
        this.messageFactory = messageFactory;
        if (binding instanceof PolicySetAttachPoint) {
            List intents = ((PolicySetAttachPoint)binding).getRequiredIntents();
            for (Intent intent : intents) {
                if (!intent.getName().equals(AUTEHTICATION_INTENT)) continue;
                this.requiresAuthentication = true;
            }
            List policySets = ((PolicySetAttachPoint)binding).getApplicablePolicySets();
            for (PolicySet ps : policySets) {
                for (Object p : ps.getPolicies()) {
                    if (!BasicAuthenticationPolicy.class.isInstance(p)) continue;
                    this.basicAuthenticationPolicy = (BasicAuthenticationPolicy)p;
                }
            }
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.requiresAuthentication && !this.hasAuthorization(request, (ServletResponse)response)) {
            response.setHeader("WWW-Authenticate", "BASIC realm=\"Tuscany\"");
            response.sendError(401);
        }
        super.service(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int n;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        if (path.length() == 0) {
            response.sendRedirect(request.getRequestURL().append('/').toString());
            return;
        }
        Message requestMessage = this.messageFactory.createMessage();
        requestMessage.getHeaders().addAll(HTTPHeadersParser.getHeaders(request));
        String id = path.substring(1);
        Message responseMessage = null;
        HTTPCacheContext cacheContext = null;
        try {
            cacheContext = HTTPCacheContext.getCacheContextFromRequest((HttpServletRequest)request);
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (cacheContext != null && cacheContext.isEnabled() && this.conditionalGetInvoker != null) {
            requestMessage.setBody((Object)new Object[]{id, cacheContext});
            responseMessage = this.conditionalGetInvoker.invoke(requestMessage);
        } else {
            requestMessage.setBody((Object)new Object[]{id});
            responseMessage = this.getInvoker.invoke(requestMessage);
        }
        if (responseMessage.isFault()) {
            Object body = responseMessage.getBody();
            int index = -1;
            index = body.getClass().getName().indexOf("NotModifiedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(304, body.toString().substring(index));
                } else {
                    response.sendError(304);
                }
                return;
            }
            index = body.getClass().getName().indexOf("PreconditionFailedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(412, body.toString().substring(index));
                } else {
                    response.sendError(412);
                }
                return;
            }
            throw new ServletException((Throwable)responseMessage.getBody());
        }
        InputStream is = (InputStream)responseMessage.getBody();
        ServletOutputStream os = response.getOutputStream();
        byte[] buffer = new byte[2048];
        while ((n = is.read(buffer)) > 0) {
            os.write(buffer, 0, n);
        }
        os.flush();
        os.close();
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int n;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        if (path.length() == 0) {
            response.sendRedirect(request.getRequestURL().append('/').toString());
            return;
        }
        Message requestMessage = this.messageFactory.createMessage();
        String id = path.substring(1);
        Message responseMessage = null;
        HTTPCacheContext cacheContext = null;
        try {
            cacheContext = HTTPCacheContext.getCacheContextFromRequest((HttpServletRequest)request);
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (cacheContext != null && cacheContext.isEnabled() && this.conditionalDeleteInvoker != null) {
            requestMessage.setBody((Object)new Object[]{id, cacheContext});
            responseMessage = this.conditionalDeleteInvoker.invoke(requestMessage);
        } else {
            requestMessage.setBody((Object)new Object[]{id});
            responseMessage = this.deleteInvoker.invoke(requestMessage);
        }
        if (responseMessage.isFault()) {
            Object body = responseMessage.getBody();
            int index = -1;
            index = body.getClass().getName().indexOf("NotModifiedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(304, body.toString().substring(index));
                } else {
                    response.sendError(304);
                }
                return;
            }
            index = body.getClass().getName().indexOf("PreconditionFailedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(412, body.toString().substring(index));
                } else {
                    response.sendError(412);
                }
                return;
            }
            throw new ServletException((Throwable)responseMessage.getBody());
        }
        InputStream is = (InputStream)responseMessage.getBody();
        ServletOutputStream os = response.getOutputStream();
        byte[] buffer = new byte[2048];
        while ((n = is.read(buffer)) > 0) {
            os.write(buffer, 0, n);
        }
        os.flush();
        os.close();
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int n;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        if (path.length() == 0) {
            response.sendRedirect(request.getRequestURL().append('/').toString());
            return;
        }
        Message requestMessage = this.messageFactory.createMessage();
        String id = path.substring(1);
        Message responseMessage = null;
        HTTPCacheContext cacheContext = null;
        try {
            cacheContext = HTTPCacheContext.getCacheContextFromRequest((HttpServletRequest)request);
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (cacheContext != null && cacheContext.isEnabled() && this.conditionalPutInvoker != null) {
            requestMessage.setBody((Object)new Object[]{id, cacheContext});
            responseMessage = this.conditionalPutInvoker.invoke(requestMessage);
        } else {
            requestMessage.setBody((Object)new Object[]{id});
            responseMessage = this.putInvoker.invoke(requestMessage);
        }
        if (responseMessage.isFault()) {
            Object body = responseMessage.getBody();
            int index = -1;
            index = body.getClass().getName().indexOf("NotModifiedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(304, body.toString().substring(index));
                } else {
                    response.sendError(304);
                }
                return;
            }
            index = body.getClass().getName().indexOf("PreconditionFailedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(412, body.toString().substring(index));
                } else {
                    response.sendError(412);
                }
                return;
            }
            throw new ServletException((Throwable)responseMessage.getBody());
        }
        InputStream is = (InputStream)responseMessage.getBody();
        ServletOutputStream os = response.getOutputStream();
        byte[] buffer = new byte[2048];
        while ((n = is.read(buffer)) > 0) {
            os.write(buffer, 0, n);
        }
        os.flush();
        os.close();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HTTPCacheContext cc;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        if (path.length() == 0) {
            response.sendRedirect(request.getRequestURL().append('/').toString());
            return;
        }
        Message requestMessage = this.messageFactory.createMessage();
        Message responseMessage = null;
        HTTPCacheContext cacheContext = null;
        try {
            cacheContext = HTTPCacheContext.getCacheContextFromRequest((HttpServletRequest)request);
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (cacheContext != null && cacheContext.isEnabled() && this.conditionalPostInvoker != null) {
            requestMessage.setBody((Object)new Object[]{cacheContext});
            responseMessage = this.conditionalPostInvoker.invoke(requestMessage);
        } else {
            requestMessage.setBody((Object)new Object[0]);
            responseMessage = this.postInvoker.invoke(requestMessage);
        }
        if (responseMessage.isFault()) {
            Object body = responseMessage.getBody();
            int index = -1;
            index = body.getClass().getName().indexOf("NotModifiedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(304, body.toString().substring(index));
                } else {
                    response.sendError(304);
                }
                return;
            }
            index = body.getClass().getName().indexOf("PreconditionFailedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(412, body.toString().substring(index));
                } else {
                    response.sendError(412);
                }
                return;
            }
            throw new ServletException((Throwable)responseMessage.getBody());
        }
        Object body = responseMessage.getBody();
        if (body.getClass() == HTTPCacheContext.class && (cc = (HTTPCacheContext)responseMessage.getBody()) != null && cc.isEnabled()) {
            String lastModified;
            String eTag = cc.getETag();
            if (eTag != null) {
                response.setHeader("ETag", cc.getETag());
            }
            if ((lastModified = cc.getLastModified()) != null) {
                response.setHeader("LastModified", cc.getLastModified());
            }
        }
    }

    public Invoker getGetInvoker() {
        return this.getInvoker;
    }

    public void setGetInvoker(Invoker getInvoker) {
        this.getInvoker = getInvoker;
    }

    public Invoker getConditionalGetInvoker() {
        return this.conditionalGetInvoker;
    }

    public void setConditionalGetInvoker(Invoker conditionalGetInvoker) {
        this.conditionalGetInvoker = conditionalGetInvoker;
    }

    public Invoker getPutInvoker() {
        return this.putInvoker;
    }

    public void setPutInvoker(Invoker putInvoker) {
        this.putInvoker = putInvoker;
    }

    public Invoker getConditionalPutInvoker() {
        return this.conditionalPutInvoker;
    }

    public void setConditionalPutInvoker(Invoker conditionalPutInvoker) {
        this.conditionalPutInvoker = conditionalPutInvoker;
    }

    public Invoker getPostInvoker() {
        return this.postInvoker;
    }

    public void setPostInvoker(Invoker postInvoker) {
        this.postInvoker = postInvoker;
    }

    public Invoker getConditionalPostInvoker() {
        return this.conditionalPostInvoker;
    }

    public void setConditionalPostInvoker(Invoker conditionalPostInvoker) {
        this.conditionalPostInvoker = conditionalPostInvoker;
    }

    public Invoker getDeleteInvoker() {
        return this.deleteInvoker;
    }

    public void setDeleteInvoker(Invoker deleteInvoker) {
        this.deleteInvoker = deleteInvoker;
    }

    public Invoker getConditionalDeleteInvoker() {
        return this.conditionalDeleteInvoker;
    }

    public void setConditionalDeleteInvoker(Invoker conditionalDeleteInvoker) {
        this.conditionalDeleteInvoker = conditionalDeleteInvoker;
    }

    private boolean hasAuthorization(HttpServletRequest request, ServletResponse response) {
        boolean result = false;
        if (request.getHeader("Authorization") != null) {
            result = true;
        }
        return result;
    }
}

