/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.provider;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.http.HTTPBindingContext;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;

public class HTTPRRBListenerServlet
extends HttpServlet {
    private static final long serialVersionUID = 6688524143716091739L;
    private transient Binding binding;
    private transient Invoker bindingInvoker;
    private transient MessageFactory messageFactory;

    public HTTPRRBListenerServlet(Binding binding, Invoker bindingInvoker, MessageFactory messageFactory) {
        this.binding = binding;
        this.bindingInvoker = bindingInvoker;
        this.messageFactory = messageFactory;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int ret;
        String charset = request.getCharacterEncoding();
        if (charset == null) {
            charset = "UTF-8";
        }
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), charset));
        CharArrayWriter data = new CharArrayWriter();
        char[] buf = new char[4096];
        while ((ret = in.read(buf, 0, 4096)) != -1) {
            data.write(buf, 0, ret);
        }
        HTTPBindingContext bindingContext = new HTTPBindingContext();
        bindingContext.setHttpRequest(request);
        bindingContext.setHttpResponse(response);
        Message requestMessage = this.messageFactory.createMessage();
        requestMessage.setBindingContext((Object)bindingContext);
        requestMessage.setBody((Object)new Object[]{data});
        Message responseMessage = this.bindingInvoker.invoke(requestMessage);
        if (responseMessage.isFault()) {
            Throwable e = (Throwable)responseMessage.getBody();
            response.sendError(500, e.toString());
        } else {
            byte[] bout = responseMessage.getBody().toString().getBytes("UTF-8");
            response.getOutputStream().write(bout);
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }
}

