/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.provider;

import javax.servlet.Servlet;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.OperationSelector;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.HTTPDefaultOperationSelector;
import org.apache.tuscany.sca.binding.http.HTTPDefaultWireFormat;
import org.apache.tuscany.sca.binding.http.provider.HTTPBindingListenerServlet;
import org.apache.tuscany.sca.binding.http.provider.HTTPBindingServiceServlet;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.EndpointProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.provider.WireFormatProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class HTTPServiceBindingProvider
implements EndpointProvider {
    private ExtensionPointRegistry extensionPoints;
    private RuntimeEndpoint endpoint;
    private HTTPBinding binding;
    private MessageFactory messageFactory;
    private OperationSelectorProvider osProvider;
    private WireFormatProvider wfProvider;
    private ServletHost servletHost;
    private String servletMapping;
    private InterfaceContract interfaceContract;
    private boolean widget;
    private HTTPBindingListenerServlet bindingListenerServlet;

    public HTTPServiceBindingProvider(RuntimeEndpoint endpoint, ExtensionPointRegistry extensionPoints, MessageFactory messageFactory, ServletHost servletHost) {
        WireFormatProviderFactory wfProviderFactory;
        OperationSelectorProviderFactory osProviderFactory;
        this.endpoint = endpoint;
        this.binding = (HTTPBinding)endpoint.getBinding();
        this.widget = "Widget".equals(this.binding.getName());
        this.extensionPoints = extensionPoints;
        this.messageFactory = messageFactory;
        this.servletHost = servletHost;
        if (this.binding.getOperationSelector() == null && !this.widget) {
            this.binding.setOperationSelector((OperationSelector)new HTTPDefaultOperationSelector());
        }
        if (this.binding.getRequestWireFormat() == null && !this.widget) {
            this.binding.setRequestWireFormat((WireFormat)new HTTPDefaultWireFormat());
        }
        if (this.binding.getResponseWireFormat() == null && !this.widget) {
            this.binding.setResponseWireFormat((WireFormat)new HTTPDefaultWireFormat());
        }
        ProviderFactoryExtensionPoint providerFactories = (ProviderFactoryExtensionPoint)extensionPoints.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        if (this.binding.getOperationSelector() != null && (osProviderFactory = (OperationSelectorProviderFactory)providerFactories.getProviderFactory(this.binding.getOperationSelector().getClass())) != null) {
            this.osProvider = osProviderFactory.createServiceOperationSelectorProvider(endpoint);
        }
        if (this.binding.getRequestWireFormat() != null && this.binding.getResponseWireFormat() != null && (wfProviderFactory = (WireFormatProviderFactory)providerFactories.getProviderFactory(this.binding.getRequestWireFormat().getClass())) != null) {
            this.wfProvider = wfProviderFactory.createServiceWireFormatProvider(endpoint);
        }
        try {
            this.interfaceContract = (InterfaceContract)endpoint.getComponentServiceInterfaceContract().clone();
            if (this.wfProvider != null) {
                this.wfProvider.configureWireFormatInterfaceContract(this.interfaceContract);
            }
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        this.servletMapping = this.binding.getURI();
        if (!this.servletMapping.endsWith("/")) {
            this.servletMapping = this.servletMapping + "/";
        }
        if (!this.servletMapping.endsWith("*")) {
            this.servletMapping = this.servletMapping + "*";
        }
    }

    public void start() {
        if (this.widget) {
            this.start1x();
        } else {
            this.servletHost.addServletMapping(this.servletMapping, (Servlet)new HTTPBindingServiceServlet(this.endpoint, this.messageFactory));
        }
    }

    public void start1x() {
        HTTPBindingListenerServlet servlet = null;
        this.bindingListenerServlet = new HTTPBindingListenerServlet((Binding)this.binding, this.messageFactory);
        for (InvocationChain invocationChain : this.endpoint.getInvocationChains()) {
            Operation operation = invocationChain.getTargetOperation();
            String operationName = operation.getName();
            if (operationName.equals("get")) {
                Invoker getInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setGetInvoker(getInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalGet")) {
                Invoker conditionalGetInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalGetInvoker(conditionalGetInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("delete")) {
                Invoker deleteInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setDeleteInvoker(deleteInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalDelete")) {
                Invoker conditionalDeleteInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalDeleteInvoker(conditionalDeleteInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("put")) {
                Invoker putInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setPutInvoker(putInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalPut")) {
                Invoker conditionalPutInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalPutInvoker(conditionalPutInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("post")) {
                Invoker postInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setPostInvoker(postInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalPost")) {
                Invoker conditionalPostInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalPostInvoker(conditionalPostInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (!operationName.equals("service")) continue;
            Invoker serviceInvoker = invocationChain.getHeadInvoker();
            break;
        }
        if (servlet == null) {
            throw new IllegalStateException("No get or service method found on the service");
        }
        this.servletMapping = this.binding.getURI();
        if (!this.servletMapping.endsWith("/")) {
            this.servletMapping = this.servletMapping + "/";
        }
        if (!this.servletMapping.endsWith("*")) {
            this.servletMapping = this.servletMapping + "*";
        }
        this.servletHost.addServletMapping(this.servletMapping, servlet);
    }

    public void stop() {
        this.servletHost.removeServletMapping(this.servletMapping);
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.interfaceContract;
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void configure() {
        if (this.widget) {
            return;
        }
        InvocationChain bindingChain = this.endpoint.getBindingInvocationChain();
        if (this.osProvider != null) {
            bindingChain.addInterceptor("service.binding.operationselector", this.osProvider.createInterceptor());
        }
        if (this.wfProvider != null) {
            bindingChain.addInterceptor("service.binding.wireformat", this.wfProvider.createInterceptor());
        }
    }
}

