/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.format;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.common.xml.dom.DOMHelper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.oasisopen.sca.ServiceRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class HTTPXMLWireFormatServiceInterceptor
implements Interceptor {
    private Invoker next;
    private DOMHelper domHelper;

    public HTTPXMLWireFormatServiceInterceptor(RuntimeEndpoint endpoint, DOMHelper domHelper) {
        this.domHelper = domHelper;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Invoker getNext() {
        return this.next;
    }

    public Message invoke(Message msg) {
        try {
            return this.invokeResponse(this.getNext().invoke(this.invokeRequest(msg)));
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private Message invokeRequest(Message msg) throws IOException, SAXException {
        HTTPContext context = (HTTPContext)msg.getBindingContext();
        HttpServletRequest servletRequest = context.getHttpRequest();
        if ("GET".equals(servletRequest.getMethod())) {
            msg.setBody((Object)this.getRequestFromQueryString(msg.getOperation(), (ServletRequest)servletRequest));
        } else {
            msg.setBody((Object)new Object[]{this.domHelper.load(HTTPXMLWireFormatServiceInterceptor.read(servletRequest))});
        }
        return msg;
    }

    private Message invokeResponse(Message msg) throws IOException {
        HTTPContext context = (HTTPContext)msg.getBindingContext();
        HttpServletResponse servletResponse = context.getHttpResponse();
        servletResponse.setContentType("text/xml");
        Object o = msg.getBody();
        if (msg.isFault()) {
            String xml = this.domHelper.saveAsString((Node)((FaultException)o).getFaultInfo());
            servletResponse.sendError(500, xml);
        } else {
            String xml = "";
            if (o instanceof Element) {
                xml = this.domHelper.saveAsString((Node)o);
            } else if (o instanceof Object[] && ((Object[])o)[0] instanceof Node) {
                xml = this.domHelper.saveAsString((Node)((Object[])o)[0]);
            } else if (o != null) {
                throw new IllegalStateException("expecting Node payload: " + o);
            }
            servletResponse.getOutputStream().println(xml);
        }
        return msg;
    }

    protected Object[] getRequestFromQueryString(Operation operation, ServletRequest servletRequest) throws IOException, SAXException {
        ArrayList<Document> xmlRequestArray = new ArrayList<Document>();
        for (String name : this.getOrderedParameterNames(servletRequest)) {
            xmlRequestArray.add(this.domHelper.load("<" + name + ">" + servletRequest.getParameter(name) + "</" + name + ">"));
        }
        return xmlRequestArray.toArray();
    }

    protected List<String> getOrderedParameterNames(ServletRequest servletRequest) {
        ArrayList<String> orderedNames = new ArrayList<String>();
        Set parameterNames = servletRequest.getParameterMap().keySet();
        if (parameterNames.contains("arg0")) {
            String name;
            for (int i = 0; i < parameterNames.size() && parameterNames.contains(name = "arg" + i); ++i) {
                orderedNames.add(name);
            }
        } else {
            final String queryString = ((HttpServletRequest)servletRequest).getQueryString();
            TreeSet<String> sortedNames = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int i = queryString.indexOf(o1);
                    int j = queryString.indexOf(o2);
                    return i - j;
                }
            });
            for (String name : parameterNames) {
                sortedNames.add(name);
            }
            orderedNames.addAll(sortedNames);
        }
        return orderedNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String read(HttpServletRequest servletRequest) throws IOException {
        ServletInputStream is = servletRequest.getInputStream();
        BufferedReader reader = null;
        try {
            String str;
            reader = new BufferedReader(new InputStreamReader((InputStream)is));
            StringBuffer sb = new StringBuffer();
            while ((str = reader.readLine()) != null) {
                sb.append(str);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

