/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.format;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.oasisopen.sca.ServiceRuntimeException;

public class HTTPDefaultServiceOperationSelectorInterceptor
implements Interceptor {
    private Invoker next;
    private List<Operation> operations;

    public HTTPDefaultServiceOperationSelectorInterceptor(RuntimeEndpoint endpoint) {
        Interface serviceInterface = endpoint.getService().getInterfaceContract().getInterface();
        this.operations = serviceInterface.getOperations();
    }

    public Message invoke(Message msg) {
        HTTPContext context = (HTTPContext)msg.getBindingContext();
        HttpServletRequest request = context.getHttpRequest();
        String path = request.getPathInfo();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        for (Operation op : this.operations) {
            if (!op.getName().equals(path)) continue;
            msg.setOperation(op);
            return this.next.invoke(msg);
        }
        throw new ServiceRuntimeException("No matching operation: " + path);
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Invoker getNext() {
        return this.next;
    }
}

