/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.provider;

import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.provider.HTTPServiceBindingProvider;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostHelper;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPBindingProviderFactory
implements BindingProviderFactory<HTTPBinding> {
    private ExtensionPointRegistry extensionPoints;
    private MessageFactory messageFactory;
    private ServletHost servletHost;

    public HTTPBindingProviderFactory(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
        this.servletHost = ServletHostHelper.getServletHost((ExtensionPointRegistry)extensionPoints);
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.messageFactory = (MessageFactory)modelFactories.getFactory(MessageFactory.class);
    }

    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeEndpointReference endpointReference) {
        return null;
    }

    public ServiceBindingProvider createServiceBindingProvider(RuntimeEndpoint endpoint) {
        return new HTTPServiceBindingProvider(endpoint, this.extensionPoints, this.messageFactory, this.servletHost);
    }

    public Class<HTTPBinding> getModelType() {
        return HTTPBinding.class;
    }
}

