/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.provider;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.provider.HTTPBindingListenerServlet;
import org.apache.tuscany.sca.binding.http.provider.HTTPServiceListenerServlet;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.EndpointProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.provider.WireFormatProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class HTTPServiceBindingProvider
implements EndpointProvider {
    private ExtensionPointRegistry extensionPoints;
    private RuntimeEndpoint endpoint;
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private InterfaceContract serviceContract;
    private HTTPBinding binding;
    private MessageFactory messageFactory;
    private OperationSelectorProvider osProvider;
    private WireFormatProvider wfProvider;
    private ServletHost servletHost;
    private String servletMapping;
    private HTTPBindingListenerServlet bindingListenerServlet;

    public HTTPServiceBindingProvider(RuntimeEndpoint endpoint, ExtensionPointRegistry extensionPoints, MessageFactory messageFactory, ServletHost servletHost) {
        WireFormatProviderFactory wfProviderFactory;
        OperationSelectorProviderFactory osProviderFactory;
        this.endpoint = endpoint;
        this.component = (RuntimeComponent)endpoint.getComponent();
        this.service = (RuntimeComponentService)endpoint.getService();
        this.binding = (HTTPBinding)endpoint.getBinding();
        this.extensionPoints = extensionPoints;
        this.messageFactory = messageFactory;
        this.servletHost = servletHost;
        ProviderFactoryExtensionPoint providerFactories = (ProviderFactoryExtensionPoint)extensionPoints.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        if (this.binding.getOperationSelector() != null && (osProviderFactory = (OperationSelectorProviderFactory)providerFactories.getProviderFactory(this.binding.getOperationSelector().getClass())) != null) {
            this.osProvider = osProviderFactory.createServiceOperationSelectorProvider(endpoint);
        }
        if (this.binding.getRequestWireFormat() != null && this.binding.getResponseWireFormat() != null && (wfProviderFactory = (WireFormatProviderFactory)providerFactories.getProviderFactory(this.binding.getRequestWireFormat().getClass())) != null) {
            this.wfProvider = wfProviderFactory.createServiceWireFormatProvider(endpoint);
        }
        try {
            this.serviceContract = (InterfaceContract)this.service.getInterfaceContract().clone();
            if (this.wfProvider != null) {
                this.wfProvider.configureWireFormatInterfaceContract(this.service.getInterfaceContract());
            }
        }
        catch (CloneNotSupportedException e) {
            this.serviceContract = this.service.getInterfaceContract();
        }
    }

    public void start() {
        Object servlet = null;
        this.bindingListenerServlet = new HTTPBindingListenerServlet((Binding)this.binding, this.messageFactory);
        for (InvocationChain invocationChain : this.endpoint.getInvocationChains()) {
            Operation operation = invocationChain.getTargetOperation();
            String operationName = operation.getName();
            if (operationName.equals("get")) {
                Invoker getInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setGetInvoker(getInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalGet")) {
                Invoker conditionalGetInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalGetInvoker(conditionalGetInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("delete")) {
                Invoker deleteInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setDeleteInvoker(deleteInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalDelete")) {
                Invoker conditionalDeleteInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalDeleteInvoker(conditionalDeleteInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("put")) {
                Invoker putInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setPutInvoker(putInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalPut")) {
                Invoker conditionalPutInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalPutInvoker(conditionalPutInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("post")) {
                Invoker postInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setPostInvoker(postInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalPost")) {
                Invoker conditionalPostInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalPostInvoker(conditionalPostInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (!operationName.equals("service")) continue;
            Invoker serviceInvoker = invocationChain.getHeadInvoker();
            servlet = new HTTPServiceListenerServlet((Binding)this.binding, serviceInvoker, this.messageFactory);
            break;
        }
        if (servlet == null) {
            throw new IllegalStateException("No get or service method found on the service");
        }
        this.servletMapping = this.binding.getURI();
        if (!this.servletMapping.endsWith("/")) {
            this.servletMapping = this.servletMapping + "/";
        }
        if (!this.servletMapping.endsWith("*")) {
            this.servletMapping = this.servletMapping + "*";
        }
        this.servletHost.addServletMapping(this.servletMapping, servlet);
    }

    public void stop() {
        this.servletHost.removeServletMapping(this.servletMapping);
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.service.getInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void configure() {
        InvocationChain bindingChain = this.endpoint.getBindingInvocationChain();
        if (this.osProvider != null) {
            bindingChain.addInterceptor("service.binding.operationselector", this.osProvider.createInterceptor());
        }
        if (this.wfProvider != null) {
            bindingChain.addInterceptor("service.binding.wireformat", this.wfProvider.createInterceptor());
        }
    }
}

