/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.wireformat.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.oasisopen.sca.ServiceRuntimeException;

public class HTTPJSONWireFormatServiceInterceptor
implements Interceptor {
    private Invoker next;
    private String jsonpCallbackName = "callback";

    public HTTPJSONWireFormatServiceInterceptor(RuntimeEndpoint endpoint) {
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Invoker getNext() {
        return this.next;
    }

    public Message invoke(Message msg) {
        try {
            return this.invokeResponse(this.getNext().invoke(this.invokeRequest(msg)));
        }
        catch (IOException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private Message invokeRequest(Message msg) throws IOException {
        HTTPContext context = (HTTPContext)msg.getBindingContext();
        HttpServletRequest servletRequest = context.getHttpRequest();
        if ("GET".equals(servletRequest.getMethod())) {
            msg.setBody((Object)this.getRequestFromQueryString(msg.getOperation(), (ServletRequest)servletRequest));
        } else {
            msg.setBody((Object)this.getRequestFromPost(msg.getOperation(), servletRequest));
        }
        return msg;
    }

    private Object[] getRequestFromPost(Operation operation, HttpServletRequest servletRequest) throws IOException {
        ArrayList<Object> os = new ArrayList<Object>();
        String data = HTTPJSONWireFormatServiceInterceptor.read(servletRequest);
        if (data.length() > 0) {
            if (data.startsWith("[") && data.endsWith("]")) {
                data = data.substring(1, data.length() - 1);
                StringTokenizer st = new StringTokenizer(data, ",");
                while (st.hasMoreElements()) {
                    os.add(st.nextElement());
                }
            } else {
                os.add(data);
            }
        }
        return os.toArray();
    }

    private Message invokeResponse(Message msg) throws IOException {
        HTTPContext context = (HTTPContext)msg.getBindingContext();
        HttpServletRequest servletRequest = context.getHttpRequest();
        HttpServletResponse servletResponse = context.getHttpResponse();
        if (msg.isFault()) {
            servletResponse.sendError(500, String.valueOf(msg.getBody()));
        } else {
            String response = this.getResponseAsString(servletRequest, servletResponse, msg.getBody());
            servletResponse.getOutputStream().println(response);
        }
        return msg;
    }

    protected Object[] getRequestFromQueryString(Operation operation, ServletRequest servletRequest) {
        List types = (List)operation.getInputType().getLogical();
        int typesIndex = 0;
        ArrayList<String> jsonRequestArray = new ArrayList<String>();
        for (String name : this.getOrderedParameterNames(servletRequest)) {
            String x;
            String jsonRequest = "";
            jsonRequest = typesIndex < types.size() && String.class.equals((Object)((DataType)types.get(typesIndex++)).getGenericType()) ? ((x = servletRequest.getParameter(name)).startsWith("\"") || x.startsWith("'") ? jsonRequest + x : (x.contains("\"") ? jsonRequest + "'" + x + "'" : jsonRequest + "\"" + x + "\"")) : jsonRequest + servletRequest.getParameter(name);
            jsonRequestArray.add(jsonRequest);
        }
        return jsonRequestArray.toArray();
    }

    protected List<String> getOrderedParameterNames(ServletRequest servletRequest) {
        ArrayList<String> orderedNames = new ArrayList<String>();
        Set parameterNames = servletRequest.getParameterMap().keySet();
        if (parameterNames.contains("arg0")) {
            String name;
            for (int i = 0; i < parameterNames.size() && parameterNames.contains(name = "arg" + i); ++i) {
                orderedNames.add(name);
            }
        } else {
            final String queryString = ((HttpServletRequest)servletRequest).getQueryString();
            TreeSet<String> sortedNames = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int i = queryString.indexOf(o1);
                    int j = queryString.indexOf(o2);
                    return i - j;
                }
            });
            for (String name : parameterNames) {
                if (name.startsWith("_") || name.equals(this.jsonpCallbackName)) continue;
                sortedNames.add(name);
            }
            orderedNames.addAll(sortedNames);
        }
        return orderedNames;
    }

    protected String getResponseAsString(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object response) {
        String callback;
        String jsonResponse;
        String string = jsonResponse = response == null ? "" : response.toString();
        if ("GET".equals(servletRequest.getMethod()) && (callback = servletRequest.getParameter(this.jsonpCallbackName)) != null && callback.length() > 1) {
            jsonResponse = callback + "(" + jsonResponse + ");";
        }
        return jsonResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String read(HttpServletRequest servletRequest) throws IOException {
        ServletInputStream is = servletRequest.getInputStream();
        BufferedReader reader = null;
        try {
            String str;
            reader = new BufferedReader(new InputStreamReader((InputStream)is));
            StringBuffer sb = new StringBuffer();
            while ((str = reader.readLine()) != null) {
                sb.append(str);
            }
            String string = sb.toString().trim();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

