/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.tools.config.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundConfiguration<C extends Configuration>
extends Configuration<C> {
    private List<C> children = new ArrayList<C>();

    protected void addChild(C config) {
        this.children.add(config);
    }

    protected boolean removeChild(C config) {
        return this.children.remove(config);
    }

    protected boolean hasChildren() {
        return !this.children.isEmpty();
    }

    protected List<C> getChildren() {
        return this.children;
    }

    protected C findMatchingChild(C child) {
        return null;
    }

    @Override
    public void addConfiguration(CompoundConfiguration<C> config) {
        super.addConfiguration(config);
        for (Configuration newKid : config.getChildren()) {
            Configuration child = this.findMatchingChild(newKid);
            if (child == null) {
                this.addChild(newKid);
                continue;
            }
            child.addConfiguration(newKid);
        }
    }

    @Override
    public void validate() {
        super.validate();
        for (Configuration child : this.getChildren()) {
            child.validate();
        }
    }

    protected void appendChildren(StringBuilder out, String childrenName, String childDelim) {
        if (this.hasChildren()) {
            if (this.hasProperties()) {
                out.append(" and ");
            } else {
                out.append(" with ");
            }
            out.append(this.getChildren().size());
            out.append(' ');
            out.append(childrenName);
            for (Configuration child : this.getChildren()) {
                out.append(child);
                out.append(childDelim);
            }
        }
    }
}

