/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.util.Locale;
import java.util.Map;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.generic.ConversionTool;

@DefaultKey(value="parser")
public class ValueParser
extends ConversionTool {
    private Map source = null;

    public ValueParser() {
    }

    public ValueParser(Map source) {
        this.setSource(source);
    }

    protected void setSource(Map source) {
        this.source = source;
    }

    protected Map getSource() {
        if (this.source == null) {
            throw new NullPointerException("You must set a Map source for values to be parsed.");
        }
        return this.source;
    }

    public boolean exists(String key) {
        return this.getValue(key) != null;
    }

    public Object get(String key) {
        return this.getValue(key);
    }

    public Object getValue(String key) {
        return this.getSource().get(key);
    }

    public Object[] getValues(String key) {
        Object value = this.getValue(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.parseStringList((String)value);
        }
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        return new Object[]{value};
    }

    public String getString(String key) {
        return this.toString(this.getValue(key));
    }

    public String getString(String key, String alternate) {
        String s = this.getString(key);
        return s != null ? s : alternate;
    }

    public Boolean getBoolean(String key) {
        return this.toBoolean(this.getValue(key));
    }

    public boolean getBoolean(String key, boolean alternate) {
        Boolean bool = this.getBoolean(key);
        return bool != null ? bool : alternate;
    }

    public Boolean getBoolean(String key, Boolean alternate) {
        Boolean bool = this.getBoolean(key);
        return bool != null ? bool : alternate;
    }

    public Integer getInteger(String key) {
        return this.toInteger(this.getValue(key));
    }

    public Integer getInteger(String key, Integer alternate) {
        Integer num = this.getInteger(key);
        if (num == null) {
            return alternate;
        }
        return num;
    }

    public Double getDouble(String key) {
        return this.toDouble(this.getValue(key));
    }

    public Double getDouble(String key, Double alternate) {
        Double num = this.getDouble(key);
        if (num == null) {
            return alternate;
        }
        return num;
    }

    public Number getNumber(String key) {
        return this.toNumber(this.getValue(key));
    }

    public Locale getLocale(String key) {
        return this.toLocale(this.getValue(key));
    }

    public Number getNumber(String key, Number alternate) {
        Number n = this.getNumber(key);
        return n != null ? (Number)n : (Number)alternate;
    }

    public int getInt(String key, int alternate) {
        Number n = this.getNumber(key);
        return n != null ? n.intValue() : alternate;
    }

    public double getDouble(String key, double alternate) {
        Number n = this.getNumber(key);
        return n != null ? n.doubleValue() : alternate;
    }

    public Locale getLocale(String key, Locale alternate) {
        Locale l = this.getLocale(key);
        return l != null ? l : alternate;
    }

    public String[] getStrings(String key) {
        return this.toStrings(this.getValues(key));
    }

    public Boolean[] getBooleans(String key) {
        return this.toBooleans(this.getValues(key));
    }

    public Number[] getNumbers(String key) {
        return this.toNumbers(this.getValues(key));
    }

    public int[] getInts(String key) {
        return this.toInts(this.getValues(key));
    }

    public double[] getDoubles(String key) {
        return this.toDoubles(this.getValues(key));
    }

    public Locale[] getLocales(String key) {
        return this.toLocales(this.getValues(key));
    }
}

