/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.autocomplete;

import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractAutoCompleteBehavior
extends AbstractDefaultAjaxBehavior {
    private static final ResourceReference AUTOCOMPLETE_JS = new JavascriptResourceReference(AutoCompleteBehavior.class, "wicket-autocomplete.js");
    private static final long serialVersionUID = 1L;
    protected boolean preselect = false;
    protected AutoCompleteSettings settings = new AutoCompleteSettings();

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        this.renderAutocompleteHead(response);
    }

    private void renderAutocompleteHead(IHeaderResponse response) {
        response.renderJavascriptReference(AUTOCOMPLETE_JS);
        String id = this.getComponent().getMarkupId();
        String indicatorId = this.findIndicatorId();
        indicatorId = Strings.isEmpty((CharSequence)indicatorId) ? "null" : "'" + indicatorId + "'";
        String initJS = String.format("new Wicket.AutoComplete('%s','%s',%s,%s);", id, this.getCallbackUrl(), this.constructSettingsJS(), indicatorId);
        response.renderOnDomReadyJavascript(initJS);
    }

    protected final String constructSettingsJS() {
        StringBuilder sb = new StringBuilder();
        sb.append("{preselect: ").append(this.settings.getPreselect());
        sb.append(",maxHeight: ").append(this.settings.getMaxHeightInPx());
        sb.append(",adjustInputWidth: ").append(this.settings.isAdjustInputWidth());
        sb.append(",showListOnEmptyInput: ").append(this.settings.getShowListOnEmptyInput());
        sb.append(",showListOnFocusGain: ").append(this.settings.getShowListOnFocusGain());
        sb.append(",showCompleteListOnFocusGain: ").append(this.settings.getShowCompleteListOnFocusGain());
        if (this.settings.getCssClassName() != null) {
            sb.append(",className: '").append(this.settings.getCssClassName()).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }

    protected void onBind() {
        this.getComponent().add(new IBehavior[]{new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
            }
        }});
    }

    protected abstract void onRequest(String var1, RequestCycle var2);

    protected void respond(AjaxRequestTarget target) {
        RequestCycle requestCycle = RequestCycle.get();
        String val = requestCycle.getRequest().getParameter("q");
        this.onRequest(val, requestCycle);
    }
}

