/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.rating;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RatingPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference STAR0 = new ResourceReference(RatingPanel.class, "star0.gif");
    public static final ResourceReference STAR1 = new ResourceReference(RatingPanel.class, "star1.gif");
    private IModel<Integer> nrOfStars = new Model((Serializable)Integer.valueOf(5));
    private final IModel<Integer> nrOfVotes;
    private final IModel<Boolean> hasVoted;
    private Component ratingLabel;

    public RatingPanel(String id) {
        this(id, null, 5, true);
    }

    public RatingPanel(String id, IModel<? extends Number> rating) {
        this(id, rating, (IModel<Integer>)new Model((Serializable)Integer.valueOf(5)), null, (IModel<Boolean>)new Model((Serializable)Boolean.FALSE), true);
    }

    public RatingPanel(String id, int nrOfStars) {
        this(id, null, nrOfStars, true);
    }

    public RatingPanel(String id, IModel<? extends Number> rating, int nrOfStars, boolean addDefaultCssStyle) {
        this(id, rating, (IModel<Integer>)new Model((Serializable)Integer.valueOf(nrOfStars)), null, (IModel<Boolean>)new Model((Serializable)Boolean.FALSE), addDefaultCssStyle);
    }

    public RatingPanel(String id, IModel<? extends Number> rating, int nrOfStars, IModel<Integer> nrOfVotes, boolean addDefaultCssStyle) {
        this(id, rating, (IModel<Integer>)new Model((Serializable)Integer.valueOf(nrOfStars)), nrOfVotes, (IModel<Boolean>)new Model((Serializable)Boolean.FALSE), addDefaultCssStyle);
    }

    public RatingPanel(String id, IModel<? extends Number> rating, IModel<Integer> nrOfStars, IModel<Integer> nrOfVotes, IModel<Boolean> hasVoted, boolean addDefaultCssStyle) {
        super(id, rating);
        this.nrOfStars = this.wrap(nrOfStars);
        this.nrOfVotes = this.wrap(nrOfVotes);
        this.hasVoted = this.wrap(hasVoted);
        WebMarkupContainer rater = new WebMarkupContainer("rater");
        rater.add(new Component[]{this.newRatingStarBar("element", this.nrOfStars)});
        this.ratingLabel = this.newRatingLabel("rating", (IModel<? extends Number>)this.wrap(rating), this.nrOfVotes);
        rater.add(new Component[]{this.ratingLabel});
        rater.setOutputMarkupId(true);
        this.add(new Component[]{rater});
        this.setRenderBodyOnly(true);
        if (addDefaultCssStyle) {
            this.addDefaultCssStyle();
        }
    }

    public final void addDefaultCssStyle() {
        this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution(RatingPanel.class, (String)"RatingPanel.css")});
    }

    protected Component newRatingStarBar(String id, IModel<Integer> nrOfStars) {
        return new RatingStarBar(id, nrOfStars);
    }

    protected Component newRatingLabel(String id, IModel<? extends Number> rating, IModel<Integer> nrOfVotes) {
        StringResourceModel model;
        if (nrOfVotes == null) {
            Object[] parameters = new Object[]{rating};
            model = new StringResourceModel("rating.simple", (Component)this, null, parameters);
        } else {
            Object[] parameters = new Object[]{rating, nrOfVotes};
            model = new StringResourceModel("rating.complete", (Component)this, null, parameters);
        }
        return new Label(id, (IModel)model);
    }

    protected String getActiveStarUrl(int iteration) {
        return ((Object)this.getRequestCycle().urlFor(STAR1)).toString();
    }

    protected String getInactiveStarUrl(int iteration) {
        return ((Object)this.getRequestCycle().urlFor(STAR0)).toString();
    }

    public RatingPanel setRatingLabelVisible(boolean visible) {
        this.ratingLabel.setVisible(visible);
        return this;
    }

    protected abstract boolean onIsStarActive(int var1);

    protected abstract void onRated(int var1, AjaxRequestTarget var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RatingStarBar
    extends Loop {
        private static final long serialVersionUID = 1L;

        private RatingStarBar(String id, IModel<Integer> model) {
            super(id, model);
        }

        protected void populateItem(Loop.LoopItem item) {
            AjaxFallbackLink<Void> link = new AjaxFallbackLink<Void>("link"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    Loop.LoopItem item = (Loop.LoopItem)this.getParent();
                    RatingPanel.this.onRated(item.getIteration() + 1, target);
                    if (target != null) {
                        target.addComponent(RatingPanel.this.get("rater"));
                    }
                }

                public boolean isEnabled() {
                    return (Boolean)RatingPanel.this.hasVoted.getObject() == false;
                }
            };
            int iteration = item.getIteration();
            link.add(new Component[]{new WebMarkupContainer("star").add(new IBehavior[]{new SimpleAttributeModifier("src", (CharSequence)(RatingPanel.this.onIsStarActive(iteration) ? RatingPanel.this.getActiveStarUrl(iteration) : RatingPanel.this.getInactiveStarUrl(iteration)))})});
            item.add(new Component[]{link});
        }
    }
}

