/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table;

import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.IExportableColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class LambdaColumn<T, S>
extends AbstractColumn<T, S>
implements IExportableColumn<T, S> {
    private static final long serialVersionUID = 1L;
    private final SerializableFunction<T, ?> function;

    public LambdaColumn(IModel<String> displayModel, SerializableFunction<T, ?> function) {
        this(displayModel, null, function);
    }

    public LambdaColumn(IModel<String> displayModel, S sortProperty, SerializableFunction<T, ?> function) {
        super(displayModel, sortProperty);
        this.function = (SerializableFunction)Args.notNull(function, (String)"function");
    }

    @Override
    public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
        item.add(new Component[]{new Label(componentId, this.getDataModel(rowModel))});
    }

    @Override
    public IModel<?> getDataModel(final IModel<T> rowModel) {
        IModel<Object> dataModel = new IModel<Object>(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                Object before = rowModel.getObject();
                if (before == null) {
                    return null;
                }
                return LambdaColumn.this.function.apply(before);
            }

            public void detach() {
                rowModel.detach();
            }
        };
        return dataModel;
    }
}

