/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.factory;

import javax.xml.namespace.QName;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.NodeFactory;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMEntityReference;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.builder.OMFactoryEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.common.AxiomContainerSupport;
import org.apache.axiom.om.impl.common.AxiomElementSupport;
import org.apache.axiom.om.impl.common.AxiomNamedInformationItemSupport;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.AxiomSourcedElementSupport;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.intf.AxiomAttribute;
import org.apache.axiom.om.impl.intf.AxiomCDATASection;
import org.apache.axiom.om.impl.intf.AxiomCharacterDataNode;
import org.apache.axiom.om.impl.intf.AxiomComment;
import org.apache.axiom.om.impl.intf.AxiomContainer;
import org.apache.axiom.om.impl.intf.AxiomDocType;
import org.apache.axiom.om.impl.intf.AxiomDocument;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomEntityReference;
import org.apache.axiom.om.impl.intf.AxiomProcessingInstruction;
import org.apache.axiom.om.impl.intf.AxiomSourcedElement;
import org.apache.axiom.om.impl.intf.AxiomText;
import org.apache.axiom.om.impl.intf.TextContent;
import org.apache.axiom.util.xml.NSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMFactoryImpl
implements OMFactoryEx {
    private final OMMetaFactory metaFactory;
    private final NodeFactory nodeFactory;

    public OMFactoryImpl(OMMetaFactory metaFactory, NodeFactory nodeFactory) {
        this.metaFactory = metaFactory;
        this.nodeFactory = nodeFactory;
    }

    protected final <T extends CoreNode> T createNode(Class<T> type) {
        CoreNode node = this.nodeFactory.createNode(type);
        this.initNode(node);
        return (T)node;
    }

    protected void initNode(CoreNode node) {
    }

    public final OMMetaFactory getMetaFactory() {
        return this.metaFactory;
    }

    public final OMNamespace createOMNamespace(String uri, String prefix) {
        return new OMNamespaceImpl(uri, prefix);
    }

    public final OMDocument createOMDocument() {
        return this.createNode(AxiomDocument.class);
    }

    public final OMDocument createOMDocument(OMXMLParserWrapper builder) {
        AxiomDocument document = this.createNode(AxiomDocument.class);
        document.coreSetBuilder(builder);
        return document;
    }

    public final OMDocType createOMDocType(OMContainer parent, String rootName, String publicId, String systemId, String internalSubset) {
        return this.createOMDocType(parent, rootName, publicId, systemId, internalSubset, false);
    }

    public final OMDocType createOMDocType(OMContainer parent, String rootName, String publicId, String systemId, String internalSubset, boolean fromBuilder) {
        AxiomDocType node = this.createNode(AxiomDocType.class);
        node.coreSetRootName(rootName);
        node.coreSetPublicId(publicId);
        node.coreSetSystemId(systemId);
        node.coreSetInternalSubset(internalSubset);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)node, fromBuilder);
        }
        return node;
    }

    private AxiomText createAxiomText(OMContainer parent, Object content, int type, boolean fromBuilder) {
        AxiomText node;
        switch (type) {
            case 4: {
                node = this.createNode(AxiomCharacterDataNode.class);
                break;
            }
            case 6: {
                AxiomCharacterDataNode cdata = this.createNode(AxiomCharacterDataNode.class);
                cdata.coreSetIgnorable(true);
                node = cdata;
                break;
            }
            case 12: {
                node = this.createNode(AxiomCDATASection.class);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid node type");
            }
        }
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)node, fromBuilder);
        }
        node.coreSetCharacterData(content, AxiomSemantics.INSTANCE);
        return node;
    }

    public final OMText createOMText(OMContainer parent, String text, int type, boolean fromBuilder) {
        return this.createAxiomText(parent, text, type, fromBuilder);
    }

    public final OMText createOMText(String s, int type) {
        return this.createAxiomText(null, s, type, false);
    }

    public final OMText createOMText(String s) {
        return this.createAxiomText(null, s, 4, false);
    }

    public final OMText createOMText(OMContainer parent, String text, int type) {
        return this.createAxiomText(parent, text, type, false);
    }

    public final OMText createOMText(OMContainer parent, String text) {
        return this.createAxiomText(parent, text, 4, false);
    }

    public final OMText createOMText(OMContainer parent, char[] charArray, int type) {
        return this.createAxiomText(parent, new String(charArray), type, false);
    }

    public final OMText createOMText(OMContainer parent, QName text, int type) {
        if (text == null) {
            throw new IllegalArgumentException("QName text arg cannot be null!");
        }
        OMNamespace ns = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$handleNamespace((AxiomElement)parent, text.getNamespaceURI(), text.getPrefix());
        return this.createAxiomText(parent, ns == null ? text.getLocalPart() : String.valueOf(ns.getPrefix()) + ":" + text.getLocalPart(), type, false);
    }

    public final OMText createOMText(OMContainer parent, QName text) {
        return this.createAxiomText(parent, text, 4, false);
    }

    public final OMText createOMText(OMContainer parent, String s, String mimeType, boolean optimize) {
        return this.createAxiomText(parent, new TextContent(s, mimeType, optimize), 4, false);
    }

    public final OMText createOMText(String s, String mimeType, boolean optimize) {
        return this.createOMText(null, s, mimeType, optimize);
    }

    public final OMText createOMText(OMContainer parent, OMText source) {
        return (AxiomText)((AxiomText)source).coreClone(AxiomSemantics.CLONE_POLICY, null, (AxiomContainer)parent);
    }

    public final OMText createOMText(Object dataHandler, boolean optimize) {
        return this.createOMText(null, dataHandler, optimize, false);
    }

    public final OMText createOMText(OMContainer parent, Object dataHandler, boolean optimize, boolean fromBuilder) {
        return this.createAxiomText(parent, new TextContent(dataHandler, optimize), 4, fromBuilder);
    }

    public final OMText createOMText(String contentID, DataHandlerProvider dataHandlerProvider, boolean optimize) {
        return this.createAxiomText(null, new TextContent(contentID, dataHandlerProvider, optimize), 4, false);
    }

    public final OMProcessingInstruction createOMProcessingInstruction(OMContainer parent, String piTarget, String piData) {
        return this.createOMProcessingInstruction(parent, piTarget, piData, false);
    }

    public final OMProcessingInstruction createOMProcessingInstruction(OMContainer parent, String piTarget, String piData, boolean fromBuilder) {
        AxiomProcessingInstruction node = this.createNode(AxiomProcessingInstruction.class);
        node.coreSetTarget(piTarget);
        node.coreSetCharacterData(piData, AxiomSemantics.INSTANCE);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)node, fromBuilder);
        }
        return node;
    }

    public final OMEntityReference createOMEntityReference(OMContainer parent, String name) {
        return this.createOMEntityReference(parent, name, null, false);
    }

    public final OMEntityReference createOMEntityReference(OMContainer parent, String name, String replacementText, boolean fromBuilder) {
        AxiomEntityReference node = this.createNode(AxiomEntityReference.class);
        node.coreSetName(name);
        node.coreSetReplacementText(replacementText);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)node, fromBuilder);
        }
        return node;
    }

    public final OMComment createOMComment(OMContainer parent, String content) {
        return this.createOMComment(parent, content, false);
    }

    public final OMComment createOMComment(OMContainer parent, String content, boolean fromBuilder) {
        AxiomComment node = this.createNode(AxiomComment.class);
        node.coreSetCharacterData(content, AxiomSemantics.INSTANCE);
        if (parent != null) {
            ((OMContainerEx)parent).addChild((OMNode)node, fromBuilder);
        }
        return node;
    }

    public final OMElement createOMElement(String localName, OMNamespace ns) {
        return this.createOMElement(localName, ns, null);
    }

    public final <T extends AxiomElement> T createAxiomElement(Class<T> type, OMContainer parent, String localName, OMNamespace ns, OMXMLParserWrapper builder, boolean generateNSDecl) {
        AxiomElement element = (AxiomElement)this.createNode(type);
        element.coreSetBuilder(builder);
        if (parent != null) {
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$addChild((AxiomContainer)parent, (OMNode)element, builder != null);
        }
        AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$initName(element, localName, ns, generateNSDecl);
        return (T)element;
    }

    public final OMElement createOMElement(String localName, OMNamespace ns, OMContainer parent) {
        return this.createAxiomElement(AxiomElement.class, parent, localName, ns, null, true);
    }

    public final OMElement createOMElement(String localName, OMContainer parent, OMXMLParserWrapper builder) {
        return this.createAxiomElement(AxiomElement.class, parent, localName, null, builder, false);
    }

    public final OMElement createOMElement(QName qname, OMContainer parent) {
        AxiomElement element = this.createNode(AxiomElement.class);
        if (parent != null) {
            parent.addChild((OMNode)element);
        }
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$internalSetLocalName(element, qname.getLocalPart());
        String prefix = qname.getPrefix();
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI.length() > 0) {
            OMNamespace ns = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$findNamespace(element, namespaceURI, prefix.length() == 0 ? null : prefix);
            if (ns == null) {
                if ("".equals(prefix)) {
                    prefix = NSUtils.generatePrefix((String)namespaceURI);
                }
                ns = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$declareNamespace(element, namespaceURI, prefix);
            }
            AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$internalSetNamespace(element, ns);
        } else {
            if (prefix.length() > 0) {
                throw new IllegalArgumentException("Cannot create a prefixed element with an empty namespace name");
            }
            if (AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$getDefaultNamespace(element) != null) {
                AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$declareDefaultNamespace(element, "");
            }
            AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$internalSetNamespace(element, null);
        }
        return element;
    }

    public final OMElement createOMElement(QName qname) {
        return this.createOMElement(qname, null);
    }

    public final OMElement createOMElement(String localName, String namespaceURI, String prefix) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must not be null");
        }
        if (namespaceURI.length() == 0) {
            if (prefix != null && prefix.length() > 0) {
                throw new IllegalArgumentException("Cannot create a prefixed element with an empty namespace name");
            }
            return this.createOMElement(localName, null);
        }
        return this.createOMElement(localName, this.createOMNamespace(namespaceURI, prefix));
    }

    public final OMSourcedElement createOMElement(OMDataSource source) {
        AxiomSourcedElement element = this.createNode(AxiomSourcedElement.class);
        AxiomSourcedElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomSourcedElementSupport$org_apache_axiom_om_impl_intf_AxiomSourcedElement$init(element, source);
        return element;
    }

    public final OMSourcedElement createOMElement(OMDataSource source, String localName, OMNamespace ns) {
        AxiomSourcedElement element = this.createNode(AxiomSourcedElement.class);
        AxiomSourcedElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomSourcedElementSupport$org_apache_axiom_om_impl_intf_AxiomSourcedElement$init(element, localName, ns, source);
        return element;
    }

    public final OMSourcedElement createOMElement(OMDataSource source, QName qname) {
        AxiomSourcedElement element = this.createNode(AxiomSourcedElement.class);
        AxiomSourcedElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomSourcedElementSupport$org_apache_axiom_om_impl_intf_AxiomSourcedElement$init(element, qname, source);
        return element;
    }

    public final OMAttribute createOMAttribute(String localName, OMNamespace ns, String value) {
        if (ns != null && ns.getPrefix() == null) {
            String namespaceURI = ns.getNamespaceURI();
            ns = namespaceURI.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, NSUtils.generatePrefix((String)namespaceURI));
        }
        if (ns != null) {
            if (ns.getNamespaceURI().length() == 0) {
                if (ns.getPrefix().length() > 0) {
                    throw new IllegalArgumentException("Cannot create a prefixed attribute with an empty namespace name");
                }
                ns = null;
            } else if (ns.getPrefix().length() == 0) {
                throw new IllegalArgumentException("Cannot create an unprefixed attribute with a namespace");
            }
        }
        AxiomAttribute attr = this.createNode(AxiomAttribute.class);
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$internalSetLocalName(attr, localName);
        attr.coreSetCharacterData(value, AxiomSemantics.INSTANCE);
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$internalSetNamespace(attr, ns);
        attr.coreSetType("CDATA");
        return attr;
    }

    public final OMNode importNode(OMNode child) {
        int type = child.getType();
        switch (type) {
            case 1: {
                OMElement childElement = (OMElement)child;
                OMElement newElement = new StAXOMBuilder((OMFactory)this, childElement.getXMLStreamReader()).getDocumentElement();
                newElement.buildWithAttachments();
                return newElement;
            }
            case 4: {
                OMText newText;
                OMText importedText = (OMText)child;
                if (importedText.isBinary()) {
                    boolean isOptimize = importedText.isOptimized();
                    newText = this.createOMText(importedText.getDataHandler(), isOptimize);
                } else {
                    newText = importedText.isCharacters() ? this.createOMText(null, importedText.getTextCharacters(), importedText.getType()) : this.createOMText(null, importedText.getText());
                }
                return newText;
            }
            case 3: {
                OMProcessingInstruction importedPI = (OMProcessingInstruction)child;
                return this.createOMProcessingInstruction(null, importedPI.getTarget(), importedPI.getValue());
            }
            case 5: {
                OMComment importedComment = (OMComment)child;
                return this.createOMComment(null, importedComment.getValue());
            }
            case 11: {
                OMDocType importedDocType = (OMDocType)child;
                return this.createOMDocType(null, importedDocType.getRootName(), importedDocType.getPublicId(), importedDocType.getSystemId(), importedDocType.getInternalSubset());
            }
        }
        throw new UnsupportedOperationException("Not Implemented Yet for the given node type");
    }
}

