/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.ws.jaxme.js.JavaConstructor;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.Parameter;
import org.apache.ws.jaxme.js.pattern.InterfaceDescription;
import org.apache.ws.jaxme.js.pattern.MethodKey;

public class ProxyGenerator {
    private JavaQName extendedClass;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$NullPointerException;
    static /* synthetic */ Class class$java$lang$ClassCastException;

    public JavaQName getExtendedClass() {
        return this.extendedClass;
    }

    public void setExtendedClass(JavaQName pExtendedClass) {
        this.extendedClass = pExtendedClass;
    }

    protected JavaMethod getInterfaceMethod(JavaSource pJs, JavaMethod pMethod) {
        JavaMethod jm = pJs.newJavaMethod(pMethod);
        Parameter[] parameters = jm.getParams();
        ArrayList<String> callParameters = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (callParameters.size() > 0) {
                callParameters.add(", ");
            }
            callParameters.add(parameter.getName());
        }
        if (pMethod.getType().equals(JavaQNameImpl.VOID)) {
            jm.addLine("((", pMethod.getJavaSource().getQName(), ") backingObject).", pMethod.getName(), "(", callParameters, ");");
        } else {
            jm.addLine("return ", "((", pMethod.getJavaSource().getQName(), ") backingObject).", pMethod.getName(), "(", callParameters, ");");
        }
        return jm;
    }

    protected void generateInterfaceMethods(JavaSource pJs, Map pGeneratedMethods, JavaSource pInterface) throws ClassNotFoundException {
        JavaMethod[] methods = pInterface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            JavaMethod method = methods[i];
            if (method.isStatic() || !JavaSource.PUBLIC.equals(method.getProtection())) continue;
            MethodKey key = new MethodKey(method);
            JavaMethod existingMethod = (JavaMethod)pGeneratedMethods.get(key);
            if (existingMethod == null) {
                JavaMethod generatedMethod = this.getInterfaceMethod(pJs, method);
                pGeneratedMethods.put(key, generatedMethod);
                continue;
            }
            System.err.println("The methods " + existingMethod.getJavaSource().getQName() + "." + existingMethod.getName() + " and " + pInterface.getQName() + "." + method.getName() + " are identical, ignoring the latter.");
        }
    }

    protected JavaConstructor getConstructor(JavaSource pJs, InterfaceDescription[] pInterfaces) throws Exception {
        JavaConstructor jcon = pJs.newJavaConstructor(JavaSource.PROTECTED);
        jcon.addParam(class$java$lang$Object == null ? (class$java$lang$Object = ProxyGenerator.class$("java.lang.Object")) : class$java$lang$Object, "o");
        jcon.addIf("o == null");
        jcon.addThrowNew(class$java$lang$NullPointerException == null ? (class$java$lang$NullPointerException = ProxyGenerator.class$("java.lang.NullPointerException")) : class$java$lang$NullPointerException, (Object)JavaSource.getQuoted("The supplied object must not be null."));
        jcon.addEndIf();
        for (int i = 0; i < pInterfaces.length; ++i) {
            if (!pInterfaces[i].isMandatory()) continue;
            JavaSource js = pInterfaces[i].getJavaSource();
            jcon.addIf("!(o instanceof ", (Object)js.getQName(), (Object)")");
            jcon.addThrowNew(class$java$lang$ClassCastException == null ? ProxyGenerator.class$("java.lang.ClassCastException") : class$java$lang$ClassCastException, (Object)JavaSource.getQuoted("The supplied instance of "), (Object)" + o.getClass().getName() + ", (Object)JavaSource.getQuoted(" is not implementing "), (Object)" + ", (Object)js.getQName(), (Object)".class.getName()");
            jcon.addEndIf();
        }
        jcon.addLine("backingObject = o;");
        return jcon;
    }

    protected JavaSource getJavaSource(JavaSourceFactory pFactory, JavaQName pTargetName) {
        return pFactory.newJavaSource(pTargetName, JavaSource.PUBLIC);
    }

    protected JavaField getBackingObjectField(JavaSource pJs, InterfaceDescription[] pInterfaces) {
        return pJs.newJavaField("backingObject", class$java$lang$Object == null ? (class$java$lang$Object = ProxyGenerator.class$("java.lang.Object")) : class$java$lang$Object, JavaSource.PRIVATE);
    }

    public JavaSource generate(JavaSourceFactory pFactory, JavaQName pTargetName, InterfaceDescription[] pInterfaces) throws Exception {
        JavaSource js = this.getJavaSource(pFactory, pTargetName);
        if (this.getExtendedClass() != null) {
            js.addExtends(this.getExtendedClass());
        }
        for (int i = 0; i < pInterfaces.length; ++i) {
            JavaQName qName = pInterfaces[i].getJavaSource().getQName();
            js.addImplements(qName);
        }
        this.getBackingObjectField(js, pInterfaces);
        this.getConstructor(js, pInterfaces);
        HashMap methods = new HashMap();
        for (int i = 0; i < pInterfaces.length; ++i) {
            this.generateInterfaceMethods(js, methods, pInterfaces[i].getJavaSource());
        }
        return js;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

