/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.pattern;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.pattern.Reflector;
import org.apache.ws.jaxme.js.util.JavaParser;

public class SourceReflector
implements Reflector {
    private final File file;
    private final URL url;

    public SourceReflector(File pFile) {
        this.file = pFile;
        this.url = null;
    }

    public SourceReflector(URL pURL) {
        this.file = null;
        this.url = pURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaSource getJavaSource(JavaSourceFactory pFactory) throws RecognitionException, TokenStreamException, IOException {
        List result;
        if (this.file == null) {
            InputStream istream = null;
            try {
                istream = this.url.openStream();
                InputStreamReader r = new InputStreamReader(istream);
                result = new JavaParser(pFactory).parse(r);
                istream.close();
                istream = null;
            }
            finally {
                if (istream != null) {
                    try {
                        istream.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
        }
        FileReader r = null;
        try {
            r = new FileReader(this.file);
            result = new JavaParser(pFactory).parse(r);
            ((Reader)r).close();
            r = null;
        }
        finally {
            if (r != null) {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable ignore) {}
            }
        }
        if (result.size() > 1) {
            throw new RecognitionException("The Java source file contained multiple classes.");
        }
        if (result.size() > 1) {
            throw new RecognitionException("The Java source file contained multiple classes.");
        }
        return (JavaSource)result.get(0);
    }
}

