/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.ws.jaxme.logging.Logger;

public class Log4jLogger
implements Logger {
    private final org.apache.log4j.Logger logger;

    public Log4jLogger(String pCName) {
        this.logger = org.apache.log4j.Logger.getLogger((String)pCName);
    }

    protected String format(String pMethodName, String pMsg, Object[] pDetails) {
        StringBuffer sb = new StringBuffer(pMethodName);
        sb.append(": ").append(pMsg);
        if (pDetails != null) {
            for (int i = 0; i < pDetails.length; ++i) {
                sb.append(", ");
                sb.append(pDetails[i]);
            }
        }
        return sb.toString();
    }

    protected String format(String pMethodName, Object[] pDetails) {
        StringBuffer sb = new StringBuffer(pMethodName);
        if (pDetails != null) {
            String add = ": ";
            for (int i = 0; i < pDetails.length; ++i) {
                sb.append(add);
                add = ", ";
                sb.append(pDetails[i]);
            }
        }
        return sb.toString();
    }

    public void entering(String pMethodName, Object[] pDetails) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.format(pMethodName + " ->", pDetails));
        }
    }

    public void entering(String pMethodName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(pMethodName + " ->"));
        }
    }

    public void entering(String pMethodName, Object pDetails) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(pMethodName + " ->: " + pDetails));
        }
    }

    public void exiting(String pMethodName, Object[] pDetails) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.format(pMethodName + " <-", pDetails));
        }
    }

    public void exiting(String pMethodName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(pMethodName + " <-"));
        }
    }

    public void exiting(String pMethodName, Object pDetails) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(pMethodName + " <-: " + pDetails));
        }
    }

    public void throwing(String pMethodName, Throwable pThrowable) {
        this.logger.error((Object)pMethodName, pThrowable);
    }

    public boolean isFinestEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void finest(String pMethodName, String pMsg, Object[] pDetails) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.format(pMethodName, pMsg, pDetails));
        }
    }

    public void finest(String pMethodName, String pMsg) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(pMethodName + ": " + pMsg));
        }
    }

    public void finest(String pMethodName, String pMsg, Object pDetails) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(pMethodName + ": " + pMsg + ", " + pDetails));
        }
    }

    public void finer(String pMethodName, String pMsg, Object[] pDetails) {
        this.finest(pMethodName, pMsg, pDetails);
    }

    public boolean isFinerEnabled() {
        return this.isFinestEnabled();
    }

    public void finer(String pMethodName, String pMsg) {
        this.finest(pMethodName, pMsg);
    }

    public void finer(String pMethodName, String pMsg, Object pDetails) {
        this.finest(pMethodName, pMsg, pDetails);
    }

    public boolean isFineEnabled() {
        return this.isFinestEnabled();
    }

    public void fine(String pMethodName, String pMsg, Object[] pDetails) {
        this.finest(pMethodName, pMsg, pDetails);
    }

    public void fine(String pMethodName, String pMsg) {
        this.finest(pMethodName, pMsg);
    }

    public void fine(String pMethodName, String pMsg, Object pDetails) {
        this.finest(pMethodName, pMsg, pDetails);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String pMethodName, String pMsg, Object[] pDetails) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)this.format(pMethodName, pMsg, pDetails));
        }
    }

    public void info(String pMethodName, String pMsg) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(pMethodName + ": " + pMsg));
        }
    }

    public void info(String pMethodName, String pMsg, Object pDetails) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(pMethodName + ": " + pMsg + ", " + pDetails));
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public void warn(String pMethodName, String pMsg, Object[] pDetails) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.warn((Object)this.format(pMethodName, pMsg, pDetails));
        }
    }

    public void warn(String pMethodName, String pMsg) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.warn((Object)(pMethodName + ": " + pMsg));
        }
    }

    public void warn(String pMethodName, String pMsg, Object pDetails) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.warn((Object)(pMethodName + ": " + pMsg + ", " + pDetails));
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public void error(String pMethodName, String pMsg, Object[] pDetails) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            this.logger.error((Object)this.format(pMethodName, pMsg, pDetails));
        }
    }

    public void error(String pMethodName, String pMsg) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            this.logger.error((Object)(pMethodName + ": " + pMsg));
        }
    }

    public void error(String pMethodName, String pMsg, Object pDetails) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            this.logger.error((Object)(pMethodName + ": " + pMsg + ", " + pDetails));
        }
    }
}

