/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import org.apache.ws.jaxme.sqls.BooleanConstraint;
import org.apache.ws.jaxme.sqls.CombinedConstraint;
import org.apache.ws.jaxme.sqls.ConstrainedStatement;
import org.apache.ws.jaxme.sqls.impl.PartsImpl;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;

public class BooleanConstraintImpl
extends PartsImpl
implements BooleanConstraint {
    private BooleanConstraint.Type type;

    protected BooleanConstraintImpl(CombinedConstraint pCombinedConstraint, BooleanConstraint.Type pType) {
        super(pCombinedConstraint.getConstrainedStatement());
        if (pType == null) {
            throw new NullPointerException("The type must not be null.");
        }
        this.type = pType;
    }

    public BooleanConstraint.Type getType() {
        return this.type;
    }

    protected void add(Object pPart) {
        BooleanConstraint.Type type = this.getType();
        if (!BooleanConstraint.Type.IN.equals(type)) {
            if (BooleanConstraint.Type.ISNULL.equals(type)) {
                if (this.getNumParts() == 1) {
                    throw new IllegalStateException("An IS NULL clause cannot have more than one part.");
                }
            } else if (BooleanConstraint.Type.BETWEEN.equals(type)) {
                if (this.getNumParts() == 3) {
                    throw new IllegalStateException("A BETWEEN clause cannot have more than three parts.");
                }
            } else if (this.getNumParts() == 2) {
                throw new IllegalStateException("An " + this.getType() + " clause cannot have more than two parts.");
            }
        }
        super.add(pPart);
    }

    public ConstrainedStatement getConstrainedStatement() {
        return (ConstrainedStatement)this.getStatement();
    }

    public int getMinimumParts() {
        return 1;
    }

    public int getMaximumParts() {
        if (BooleanConstraint.Type.IN.equals(this.type)) {
            return 0;
        }
        if (BooleanConstraint.Type.EXISTS.equals(this.type) || BooleanConstraint.Type.ISNULL.equals(this.type)) {
            return 1;
        }
        if (BooleanConstraint.Type.BETWEEN.equals(this.type)) {
            return 3;
        }
        if (BooleanConstraint.Type.EQ.equals(this.type) || BooleanConstraint.Type.NE.equals(this.type) || BooleanConstraint.Type.GT.equals(this.type) || BooleanConstraint.Type.LT.equals(this.type) || BooleanConstraint.Type.GE.equals(this.type) || BooleanConstraint.Type.LE.equals(this.type) || BooleanConstraint.Type.LIKE.equals(this.type)) {
            return 2;
        }
        throw new IllegalStateException("Invalid type: " + this.type);
    }

    public static class TypeImpl
    extends SQLFactoryImpl.IdentImpl
    implements BooleanConstraint.Type {
        private static final long serialVersionUID = 3762254145096135991L;

        public TypeImpl(String pName) {
            super(pName);
        }
    }
}

