/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.sqls.SQLFactory;
import org.apache.ws.jaxme.sqls.Schema;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;
import org.apache.ws.jaxme.sqls.impl.TableImpl;

public class SchemaImpl
implements Schema {
    private SQLFactory sqlFactory;
    private Schema.Name name;
    private List tables = new ArrayList();

    protected SchemaImpl(SQLFactory pFactory, Schema.Name pName) {
        this.sqlFactory = pFactory;
        this.name = pName;
    }

    public SQLFactory getSQLFactory() {
        return this.sqlFactory;
    }

    public Schema.Name getName() {
        return this.name;
    }

    public Table newTable(String pName) {
        return this.newTable(new TableImpl.NameImpl(pName));
    }

    public Table newTable(Table.Name pName) {
        if (pName == null) {
            throw new NullPointerException("A table name must not be null.");
        }
        Integer maxLength = this.getSQLFactory().getMaxTableNameLength();
        if (maxLength != null && pName.getName().length() > maxLength) {
            throw new IllegalArgumentException("The length of the table name " + pName + " exceeds the maximum length of " + maxLength);
        }
        Table table = this.getTable(pName);
        if (table != null) {
            throw new IllegalStateException("A table named " + table.getName() + " already exists in the schema " + this.getName());
        }
        table = ((SQLFactoryImpl)this.getSQLFactory()).newTableImpl(this, pName);
        this.tables.add(table);
        return table;
    }

    public Table getTable(Table.Name pName) {
        if (pName == null) {
            throw new NullPointerException("A table name must not be null.");
        }
        Iterator iter = this.getTables();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            if (!(this.getSQLFactory().isTableNameCaseSensitive() ? pName.getName().equalsIgnoreCase(table.getName().getName()) : pName.equals(table.getName()))) continue;
            return table;
        }
        return null;
    }

    public Table getTable(String pName) {
        return this.getTable(new TableImpl.NameImpl(pName));
    }

    public Iterator getTables() {
        return this.tables.iterator();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        if (this.getName() == null) {
            return other.getName() == null;
        }
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().hashCode();
    }

    public static class NameImpl
    extends SQLFactoryImpl.IdentImpl
    implements Schema.Name {
        NameImpl(String pName) {
            super(pName);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Schema.Name)) {
                return false;
            }
            return super.equals(o);
        }
    }
}

