/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import java.util.ArrayList;
import org.apache.ws.jaxme.xs.XSAnnotation;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSIdentityConstraint;
import org.apache.ws.jaxme.xs.XSKeyRef;
import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSObjectFactory;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.impl.XSOpenAttrsImpl;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.XsAnyURI;
import org.apache.ws.jaxme.xs.xml.XsBlockSet;
import org.apache.ws.jaxme.xs.xml.XsEKey;
import org.apache.ws.jaxme.xs.xml.XsEKeyref;
import org.apache.ws.jaxme.xs.xml.XsESchema;
import org.apache.ws.jaxme.xs.xml.XsEUnique;
import org.apache.ws.jaxme.xs.xml.XsFormChoice;
import org.apache.ws.jaxme.xs.xml.XsNCName;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.apache.ws.jaxme.xs.xml.XsTElement;
import org.apache.ws.jaxme.xs.xml.XsTIdentityConstraint;
import org.apache.ws.jaxme.xs.xml.XsTTopLevelElement;
import org.xml.sax.SAXException;

public class XSElementImpl
extends XSOpenAttrsImpl
implements XSElement {
    private static final XSIdentityConstraint[] NO_CONSTRAINTS = new XSIdentityConstraint[0];
    private static final XSKeyRef[] NO_KEY_REFS = new XSKeyRef[0];
    private final XsQName name;
    private final boolean isGlobal;
    private XSAnnotation[] annotations;
    private boolean isValidated;
    private boolean isNillable;
    private XSType type;
    private XSGroup substitutionGroup;
    private XSIdentityConstraint[] identityConstraints;
    private XSKeyRef[] keyReferences;

    protected XsTElement getXsTElement() {
        return (XsTElement)this.getXsObject();
    }

    protected boolean isReference() {
        return this.getXsTElement().getRef() != null;
    }

    protected boolean isInnerSimpleType() {
        return this.getXsTElement().getSimpleType() != null;
    }

    protected boolean isInnerComplexType() {
        return this.getXsTElement().getComplexType() != null;
    }

    protected XSElementImpl(XSObject pParent, XsTElement pBaseElement) throws SAXException {
        super(pParent, pBaseElement);
        XsQName qName;
        if (this.isReference()) {
            qName = pBaseElement.getRef();
        } else {
            String namespacePrefix;
            XsAnyURI namespace;
            XsNCName myName = pBaseElement.getName();
            if (myName == null) {
                throw new LocSAXException("Invalid element: Must have either of its 'ref' or 'name' attributes set.", this.getLocator());
            }
            XsESchema schema = pBaseElement.getXsESchema();
            boolean qualified = pBaseElement.isGlobal();
            if (!qualified) {
                XsFormChoice form = pBaseElement.getForm();
                if (form == null) {
                    form = schema.getElementFormDefault();
                }
                qualified = XsFormChoice.QUALIFIED.equals(form);
            }
            if (qualified) {
                namespace = schema.getTargetNamespace();
                namespacePrefix = schema.getTargetNamespacePrefix();
            } else {
                namespace = null;
                namespacePrefix = null;
            }
            qName = new XsQName(namespace, myName.toString(), namespacePrefix);
            this.configureIdentityConstraints(pParent, pBaseElement);
        }
        this.name = qName;
        this.isGlobal = this.isReference() || pBaseElement instanceof XsTTopLevelElement;
        this.isNillable = pBaseElement.getNillable();
        this.annotations = this.getXSSchema().getXSObjectFactory().newXSAnnotations(this, pBaseElement.getAnnotation());
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean isNillable() {
        return this.isNillable;
    }

    public XsQName getName() {
        return this.name;
    }

    public XSType getType() {
        return this.type;
    }

    protected boolean isValidated() {
        return this.isValidated;
    }

    public void validate() throws SAXException {
        XSType myType;
        if (this.isValidated()) {
            return;
        }
        this.isValidated = true;
        XSSchema schema = this.getXSSchema();
        XSObjectFactory factory = schema.getXSObjectFactory();
        if (this.isReference()) {
            XSElement element = schema.getElement(this.getName());
            if (element == null) {
                throw new LocSAXException("Invalid element reference: " + this.getName() + " is not defined.", this.getLocator());
            }
            element.validate();
            this.isNillable = element.isNillable();
            myType = element.getType();
        } else {
            XsTElement element = this.getXsTElement();
            if (this.isInnerSimpleType()) {
                myType = factory.newXSType((XSObject)this, element.getSimpleType());
            } else if (this.isInnerComplexType()) {
                myType = factory.newXSType((XSObject)this, element.getComplexType());
            } else {
                XsQName typeName = element.getType();
                if (typeName == null) {
                    throw new LocSAXException("Invalid element: Either of its 'type' or 'ref' attributes or its 'simpleType' or 'complexType' children must be set.", this.getLocator());
                }
                myType = schema.getType(typeName);
                if (myType == null) {
                    throw new LocSAXException("Invalid element: The type " + typeName + " is not defined.", this.getLocator());
                }
            }
        }
        this.type = myType;
        myType.validate();
        this.validateAllIn(this.annotations);
        this.validateAllIn(this.identityConstraints);
        this.validateAllIn(this.keyReferences);
    }

    public XSAnnotation[] getAnnotations() {
        return this.annotations;
    }

    public String getDefault() {
        return this.getXsTElement().getDefault();
    }

    public String getFixed() {
        return this.getXsTElement().getFixed();
    }

    public XsQName getSubstitutionGroupName() {
        return this.getXsTElement().getSubstitutionGroup();
    }

    public boolean isBlockedForSubstitution() {
        XsBlockSet blockSet = this.getXsTElement().getBlock();
        if (blockSet == null) {
            blockSet = this.getXsTElement().getXsESchema().getBlockDefault();
        }
        return !blockSet.isSubstitutionAllowed();
    }

    public boolean isAbstract() {
        return this.getXsTElement().getAbstract();
    }

    public void setSubstitutionGroup(XSGroup pGroup) {
        this.substitutionGroup = pGroup;
    }

    public XSGroup getSubstitutionGroup() {
        return this.substitutionGroup;
    }

    public XSIdentityConstraint[] getIdentityConstraints() {
        return this.identityConstraints;
    }

    public XSKeyRef[] getKeyRefs() {
        return this.keyReferences;
    }

    private void configureIdentityConstraints(XSObject pParent, XsTElement base) throws SAXException {
        XsTIdentityConstraint[] rawConstraints = base.getIdentityConstraints();
        int numRawConstraints = rawConstraints.length;
        if (numRawConstraints == 0) {
            this.identityConstraints = NO_CONSTRAINTS;
            this.keyReferences = NO_KEY_REFS;
            return;
        }
        XSSchema schema = this.getXSSchema();
        XSObjectFactory factory = schema.getXSObjectFactory();
        ArrayList<XSIdentityConstraint> constraints = new ArrayList<XSIdentityConstraint>(1);
        ArrayList<XSKeyRef> refKeys = new ArrayList<XSKeyRef>(1);
        for (int i = 0; i < numRawConstraints; ++i) {
            XSIdentityConstraint ic;
            XsTIdentityConstraint raw = rawConstraints[i];
            if (raw instanceof XsEKeyref) {
                XSKeyRef keyRef = factory.newXSKeyRef(this, (XsEKeyref)raw);
                refKeys.add(keyRef);
                schema.add(keyRef);
                continue;
            }
            if (raw instanceof XsEKey) {
                ic = factory.newXSIdentityConstraint((XSElement)this, (XsEKey)raw);
                constraints.add(ic);
                schema.add(ic);
                continue;
            }
            if (!(raw instanceof XsEUnique)) continue;
            ic = factory.newXSIdentityConstraint((XSElement)this, (XsEUnique)raw);
            constraints.add(ic);
            schema.add(ic);
        }
        int numConstraints = constraints.size();
        this.identityConstraints = numConstraints == 0 ? NO_CONSTRAINTS : constraints.toArray(new XSIdentityConstraint[numConstraints]);
        int numKeyRefs = refKeys.size();
        this.keyReferences = numKeyRefs == 0 ? NO_KEY_REFS : refKeys.toArray(new XSKeyRef[numKeyRefs]);
    }
}

