/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.junit;

import java.io.IOException;
import java.io.StringReader;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.jaxme.xs.XSAttributable;
import org.apache.ws.jaxme.xs.XSAttribute;
import org.apache.ws.jaxme.xs.XSComplexType;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSEnumeration;
import org.apache.ws.jaxme.xs.XSParser;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.XSSimpleContentType;
import org.apache.ws.jaxme.xs.XSSimpleType;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.junit.ParserTestBase;
import org.apache.ws.jaxme.xs.types.XSID;
import org.apache.ws.jaxme.xs.types.XSString;
import org.apache.ws.jaxme.xs.util.XsDateTimeFormat;
import org.apache.ws.jaxme.xs.xml.XsAnyURI;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JiraTest
extends ParserTestBase {
    public JiraTest(String pName) {
        super(pName);
    }

    private XSSchema parse(String pSchema, String pName) throws ParserConfigurationException, SAXException, IOException {
        InputSource isource = new InputSource(new StringReader(pSchema));
        isource.setSystemId(pName);
        XSParser parser = new XSParser();
        parser.setValidating(false);
        return parser.parse(isource);
    }

    public void testJira34() throws Exception {
        String schemaSpec = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:complexType name='mixedType' mixed='true'>\n    <xs:attribute name='foo' type='xs:string'/>\n  </xs:complexType>\n</xs:schema>";
        XSSchema schema = this.parse("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:complexType name='mixedType' mixed='true'>\n    <xs:attribute name='foo' type='xs:string'/>\n  </xs:complexType>\n</xs:schema>", "jira34.xsd");
        XSType[] types = schema.getTypes();
        JiraTest.assertEquals((int)1, (int)types.length);
        XSComplexType ct = this.assertComplexType(types[0]);
        JiraTest.assertTrue((boolean)ct.isMixed());
    }

    public void testJira42() throws Exception {
        XsDateTimeFormat f = new XsDateTimeFormat();
        Calendar cal = (Calendar)f.parseObject("2004-10-15T13:00:00Z");
        JiraTest.assertEquals((int)2004, (int)cal.get(1));
        JiraTest.assertEquals((int)9, (int)cal.get(2));
        JiraTest.assertEquals((int)15, (int)cal.get(5));
        JiraTest.assertEquals((int)13, (int)cal.get(11));
        JiraTest.assertEquals((int)0, (int)cal.get(12));
        JiraTest.assertEquals((int)0, (int)cal.get(13));
        JiraTest.assertEquals((int)0, (int)cal.get(14));
        JiraTest.assertEquals((Object)TimeZone.getTimeZone("GMT"), (Object)cal.getTimeZone());
        String s = f.format(cal);
        JiraTest.assertEquals((String)"2004-10-15T13:00:00Z", (String)s);
    }

    public void testJira44() throws Exception {
        String schemaSpec = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:simpleType name='threeOrFour'>\n    <xs:restriction base='xs:string'>\n      <xs:enumeration value='3'/>\n      <xs:enumeration value='4'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:complexType name='outerType1'>\n    <xs:simpleContent>\n      <xs:extension base='threeOrFour'>\n        <xs:attribute name='isOctal' type='xs:boolean'/>\n      </xs:extension>    </xs:simpleContent>\n  </xs:complexType>\n\n  <xs:complexType name='outerType2'>\n    <xs:simpleContent>\n      <xs:restriction base='outerType1'>\n        <xs:enumeration value='4'/>\n      </xs:restriction>\n    </xs:simpleContent>\n  </xs:complexType>\n</xs:schema>";
        XSSchema schema = this.parse("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:simpleType name='threeOrFour'>\n    <xs:restriction base='xs:string'>\n      <xs:enumeration value='3'/>\n      <xs:enumeration value='4'/>\n    </xs:restriction>\n  </xs:simpleType>\n\n  <xs:complexType name='outerType1'>\n    <xs:simpleContent>\n      <xs:extension base='threeOrFour'>\n        <xs:attribute name='isOctal' type='xs:boolean'/>\n      </xs:extension>    </xs:simpleContent>\n  </xs:complexType>\n\n  <xs:complexType name='outerType2'>\n    <xs:simpleContent>\n      <xs:restriction base='outerType1'>\n        <xs:enumeration value='4'/>\n      </xs:restriction>\n    </xs:simpleContent>\n  </xs:complexType>\n</xs:schema>", "jira44.xsd");
        XSType[] types = schema.getTypes();
        JiraTest.assertEquals((int)3, (int)types.length);
        XSType threeOrFourType = types[0];
        XSSimpleType threeOrFourSimpleType = this.assertSimpleType(threeOrFourType);
        XSType restrictedType = this.assertRestriction(threeOrFourSimpleType);
        XSEnumeration[] threeOrFourTypeEnums = threeOrFourSimpleType.getEnumerations();
        JiraTest.assertEquals((int)2, (int)threeOrFourTypeEnums.length);
        JiraTest.assertEquals((String)"3", (String)threeOrFourTypeEnums[0].getValue());
        JiraTest.assertEquals((String)"4", (String)threeOrFourTypeEnums[1].getValue());
        JiraTest.assertEquals((Object)XSString.getInstance(), (Object)restrictedType);
        XSType outerType1 = types[1];
        JiraTest.assertEquals((Object)new XsQName((XsAnyURI)null, "outerType1"), (Object)outerType1.getName());
        XSComplexType outerType1complexType = this.assertComplexType(outerType1);
        XSSimpleContentType outerType1simpleContentType = this.assertSimpleContent(outerType1complexType);
        XSType outerType1contentType = outerType1simpleContentType.getType();
        JiraTest.assertEquals((Object)threeOrFourType, (Object)outerType1contentType);
        XSType outerType2 = types[2];
        JiraTest.assertEquals((Object)new XsQName((XsAnyURI)null, "outerType2"), (Object)outerType2.getName());
        XSComplexType outerType2complexType = this.assertComplexType(outerType2);
        XSSimpleContentType outerType2simpleContentType = this.assertSimpleContent(outerType2complexType);
        XSType outerType2contentType = outerType2simpleContentType.getType();
        JiraTest.assertEquals((Object)threeOrFourType, (Object)this.assertRestriction(outerType2contentType.getSimpleType()));
        XSEnumeration[] outerType2Enums = outerType2contentType.getSimpleType().getEnumerations();
        JiraTest.assertEquals((int)1, (int)outerType2Enums.length);
        JiraTest.assertEquals((String)"4", (String)outerType2Enums[0].getValue());
    }

    public void testJira46() throws Exception {
        String uri = "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/";
        String schemaSpec = "<xs:schema targetNamespace='http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/'\n    xmlns:eGov_IT='http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/'\n    xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:element name='Riferimento'>\n    <xs:complexType>\n      <xs:sequence/>\n      <xs:attribute ref='eGov_IT:id' use='required'/>\n    </xs:complexType>\n  </xs:element>\n  <xs:attribute name='id' type='xs:ID'/>\n</xs:schema>\n";
        XSSchema schema = this.parse("<xs:schema targetNamespace='http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/'\n    xmlns:eGov_IT='http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/'\n    xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:element name='Riferimento'>\n    <xs:complexType>\n      <xs:sequence/>\n      <xs:attribute ref='eGov_IT:id' use='required'/>\n    </xs:complexType>\n  </xs:element>\n  <xs:attribute name='id' type='xs:ID'/>\n</xs:schema>\n", "jira46.xsd");
        XSAttribute[] attrs = schema.getAttributes();
        JiraTest.assertEquals((int)1, (int)attrs.length);
        XSAttribute idAttr = attrs[0];
        JiraTest.assertEquals((Object)new XsQName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "id"), (Object)idAttr.getName());
        JiraTest.assertEquals((Object)XSID.getInstance(), (Object)idAttr.getType());
        JiraTest.assertTrue((boolean)idAttr.isOptional());
        XSElement[] elements = schema.getElements();
        JiraTest.assertEquals((int)1, (int)elements.length);
        XSElement rifElem = elements[0];
        XSComplexType ct = this.assertComplexType(rifElem.getType());
        XSAttributable[] rifAttrs = ct.getAttributes();
        JiraTest.assertEquals((int)1, (int)rifAttrs.length);
        XSAttribute idRef = (XSAttribute)rifAttrs[0];
        JiraTest.assertFalse((boolean)idRef.equals(idAttr));
        JiraTest.assertEquals((Object)new XsQName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "id"), (Object)idAttr.getName());
        JiraTest.assertEquals((Object)XSID.getInstance(), (Object)idAttr.getType());
        JiraTest.assertFalse((boolean)idRef.isOptional());
    }

    public void testJAXME63() throws Exception {
        String xml = "<xs:schema\n    xmlns:xs='http://www.w3.org/2001/XMLSchema'\n    elementFormDefault='qualified'>\n  <xs:group name='params'>\n    <xs:choice>\n      <xs:element name='string' type='xs:string'/>\n      <xs:element name='int' type='xs:int'/>\n      <xs:element name='boolean' type='xs:boolean'/>\n    </xs:choice>\n  </xs:group>\n  <xs:element name='call'>\n    <xs:complexType>\n      <xs:group ref='params' maxOccurs='unbounded'/>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>";
        XSSchema schema = this.parse("<xs:schema\n    xmlns:xs='http://www.w3.org/2001/XMLSchema'\n    elementFormDefault='qualified'>\n  <xs:group name='params'>\n    <xs:choice>\n      <xs:element name='string' type='xs:string'/>\n      <xs:element name='int' type='xs:int'/>\n      <xs:element name='boolean' type='xs:boolean'/>\n    </xs:choice>\n  </xs:group>\n  <xs:element name='call'>\n    <xs:complexType>\n      <xs:group ref='params' maxOccurs='unbounded'/>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>", "jaxme63.xsd");
        XSElement[] elements = schema.getElements();
        JiraTest.assertEquals((int)1, (int)elements.length);
        XSElement call = elements[0];
        JiraTest.assertEquals((Object)new XsQName((String)null, "call"), (Object)call.getName());
        XSComplexType type = this.assertComplexType(call.getType());
        XSParticle particle = this.assertComplexContent(type);
        JiraTest.assertTrue((boolean)particle.isGroup());
        this.assertChoice(particle.getGroup());
        JiraTest.assertEquals((int)1, (int)particle.getMinOccurs());
        JiraTest.assertEquals((int)-1, (int)particle.getMaxOccurs());
    }
}

