/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.junit;

import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.apache.ws.jaxme.xs.XSParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class NISTTest
extends TestCase {
    private int numOk;
    private int numFailed;
    private boolean verbose;

    public NISTTest(String pName) {
        super(pName);
    }

    public void setUp() {
        this.numFailed = 0;
        this.numOk = 0;
        this.verbose = Boolean.valueOf(System.getProperty("verbose"));
    }

    protected void log(String pMessage) {
        if (this.verbose) {
            System.out.println(pMessage);
        }
    }

    public DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder();
    }

    protected void runTest(URL pBaseURL, String pName, String pHref) throws Exception {
        String result;
        URL url = new URL(pBaseURL, pHref);
        XSParser parser = new XSParser();
        parser.setValidating(false);
        InputSource isource = new InputSource(url.openStream());
        isource.setSystemId(url.toString());
        try {
            parser.parse(isource);
            ++this.numOk;
            result = "Ok";
        }
        catch (Exception e) {
            ++this.numFailed;
            result = e.getMessage();
        }
        this.log("Running test " + pName + " with URL " + url + ": " + result);
    }

    protected void runTests(URL pBaseURL, String pName, String pHref) throws Exception {
        URL url = new URL(pBaseURL, pHref);
        InputSource isource = new InputSource(url.openStream());
        isource.setSystemId(url.toString());
        Document document = this.getDocumentBuilder().parse(isource);
        NodeList schemas = document.getElementsByTagNameNS(null, "Schema");
        for (int i = 0; i < schemas.getLength(); ++i) {
            Element schema = (Element)schemas.item(i);
            this.runTest(url, schema.getAttribute("name"), schema.getAttribute("href"));
        }
    }

    public void testNIST() throws Exception {
        String p = "NISTXMLSchemaTestSuite.location";
        String v = System.getProperty(p);
        if (v == null || v.length() == 0) {
            System.out.println("System property " + p + " is not set, skipping this test.");
            return;
        }
        URL url = new URL(v);
        url = new URL(url, "NISTXMLSchemaTestSuite.xml");
        InputSource isource = new InputSource(url.openStream());
        isource.setSystemId(url.toString());
        Document document = this.getDocumentBuilder().parse(isource);
        NodeList links = document.getElementsByTagNameNS(null, "Link");
        for (int i = 0; i < links.getLength(); ++i) {
            Element link = (Element)links.item(i);
            this.runTests(url, link.getAttribute("name"), link.getAttribute("href"));
        }
        System.out.println("Result: Passed = " + this.numOk + ", Failed = " + this.numFailed);
    }
}

