/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.junit;

import junit.framework.TestCase;
import org.apache.ws.jaxme.xs.XSAtomicType;
import org.apache.ws.jaxme.xs.XSComplexType;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSListType;
import org.apache.ws.jaxme.xs.XSModelGroup;
import org.apache.ws.jaxme.xs.XSParser;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSSimpleContentType;
import org.apache.ws.jaxme.xs.XSSimpleType;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.XSUnionType;
import org.apache.ws.jaxme.xs.jaxb.impl.JAXBParser;
import org.apache.ws.jaxme.xs.xml.XsComplexContentType;
import org.xml.sax.SAXException;

public abstract class ParserTestBase
extends TestCase {
    protected ParserTestBase(String pName) {
        super(pName);
    }

    protected XSParser newXSParser() {
        XSParser parser = new XSParser();
        parser.setValidating(false);
        return parser;
    }

    protected JAXBParser newJAXBParser() {
        JAXBParser parser = new JAXBParser();
        parser.setValidating(false);
        return parser;
    }

    protected XSComplexType assertComplexType(XSType pType) throws SAXException {
        ParserTestBase.assertTrue((!pType.isSimple() ? 1 : 0) != 0);
        XSComplexType result = pType.getComplexType();
        ParserTestBase.assertNotNull((Object)result);
        boolean haveException = false;
        try {
            pType.getSimpleType();
        }
        catch (IllegalStateException e) {
            haveException = true;
        }
        ParserTestBase.assertTrue((boolean)haveException);
        return result;
    }

    protected XSSimpleType assertSimpleType(XSType pType) throws SAXException {
        ParserTestBase.assertTrue((boolean)pType.isSimple());
        XSSimpleType result = pType.getSimpleType();
        ParserTestBase.assertNotNull((Object)result);
        boolean haveException = false;
        try {
            pType.getComplexType();
        }
        catch (IllegalStateException e) {
            haveException = true;
        }
        ParserTestBase.assertTrue((boolean)haveException);
        return result;
    }

    protected XSAtomicType assertAtomicType(XSSimpleType pType) throws SAXException {
        ParserTestBase.assertTrue((boolean)pType.isAtomic());
        ParserTestBase.assertTrue((!pType.isList() ? 1 : 0) != 0);
        ParserTestBase.assertTrue((!pType.isUnion() ? 1 : 0) != 0);
        XSAtomicType result = pType.getAtomicType();
        ParserTestBase.assertNotNull((Object)result);
        boolean haveException = false;
        try {
            pType.getListType();
        }
        catch (IllegalStateException e) {
            haveException = true;
        }
        ParserTestBase.assertTrue((boolean)haveException);
        haveException = false;
        try {
            pType.getUnionType();
        }
        catch (IllegalStateException e) {
            haveException = true;
        }
        ParserTestBase.assertTrue((boolean)haveException);
        return result;
    }

    protected XSListType assertListType(XSSimpleType pType) throws SAXException {
        ParserTestBase.assertTrue((!pType.isAtomic() ? 1 : 0) != 0);
        ParserTestBase.assertTrue((boolean)pType.isList());
        ParserTestBase.assertTrue((!pType.isUnion() ? 1 : 0) != 0);
        XSListType result = pType.getListType();
        ParserTestBase.assertNotNull((Object)result);
        boolean haveException = false;
        try {
            pType.getAtomicType();
        }
        catch (IllegalStateException e) {
            haveException = true;
        }
        ParserTestBase.assertTrue((boolean)haveException);
        haveException = false;
        try {
            pType.getUnionType();
        }
        catch (IllegalStateException e) {
            haveException = true;
        }
        ParserTestBase.assertTrue((boolean)haveException);
        return result;
    }

    protected XSUnionType assertUnionType(XSSimpleType pType) throws SAXException {
        ParserTestBase.assertTrue((!pType.isAtomic() ? 1 : 0) != 0);
        ParserTestBase.assertTrue((!pType.isList() ? 1 : 0) != 0);
        ParserTestBase.assertTrue((boolean)pType.isUnion());
        XSUnionType result = pType.getUnionType();
        ParserTestBase.assertNotNull((Object)result);
        boolean haveException = false;
        try {
            pType.getListType();
        }
        catch (IllegalStateException e) {
            haveException = true;
        }
        ParserTestBase.assertTrue((boolean)haveException);
        haveException = false;
        try {
            pType.getAtomicType();
        }
        catch (IllegalStateException e) {
            haveException = true;
        }
        ParserTestBase.assertTrue((boolean)haveException);
        return result;
    }

    protected XSType assertRestriction(XSSimpleType pType) throws SAXException {
        ParserTestBase.assertTrue((boolean)pType.isRestriction());
        XSType result = pType.getRestrictedType();
        ParserTestBase.assertNotNull((Object)result);
        this.assertSimpleType(result);
        return result;
    }

    protected XSParticle assertComplexContent(XSComplexType pType) {
        ParserTestBase.assertTrue((!pType.hasSimpleContent() ? 1 : 0) != 0);
        XSParticle result = pType.getParticle();
        ParserTestBase.assertNotNull((Object)result);
        XsComplexContentType ccType = pType.getComplexContentType();
        ParserTestBase.assertNotNull((Object)pType.getComplexContentType());
        int num = 0;
        if (pType.isElementOnly()) {
            ++num;
            ParserTestBase.assertEquals((Object)XsComplexContentType.ELEMENT_ONLY, (Object)ccType);
        }
        if (pType.isEmpty()) {
            ++num;
            ParserTestBase.assertEquals((Object)XsComplexContentType.EMPTY, (Object)ccType);
        }
        if (pType.isMixed()) {
            ++num;
            ParserTestBase.assertEquals((Object)XsComplexContentType.MIXED, (Object)ccType);
        }
        ParserTestBase.assertEquals((int)1, (int)num);
        num = 0;
        if (result.isElement()) {
            ++num;
            ParserTestBase.assertNotNull((Object)result.getElement());
            ParserTestBase.assertEquals((Object)XSParticle.ELEMENT, (Object)result.getType());
        }
        if (result.isGroup()) {
            ++num;
            ParserTestBase.assertNotNull((Object)result.getGroup());
            ParserTestBase.assertEquals((Object)XSParticle.GROUP, (Object)result.getType());
        }
        if (result.isWildcard()) {
            ++num;
            ParserTestBase.assertNotNull((Object)result.getWildcard());
            ParserTestBase.assertEquals((Object)XSParticle.WILDCARD, (Object)result.getType());
        }
        ParserTestBase.assertEquals((int)1, (int)num);
        return result;
    }

    protected XSGroup assertGroup(XSParticle pParticle) {
        ParserTestBase.assertTrue((boolean)pParticle.isGroup());
        ParserTestBase.assertEquals((Object)XSParticle.GROUP, (Object)pParticle.getType());
        XSGroup result = pParticle.getGroup();
        ParserTestBase.assertNotNull((Object)result);
        return result;
    }

    protected void assertSequence(XSGroup pGroup) {
        ParserTestBase.assertTrue((boolean)pGroup.isSequence());
        ParserTestBase.assertFalse((boolean)pGroup.isChoice());
        ParserTestBase.assertFalse((boolean)pGroup.isAll());
        ParserTestBase.assertEquals((Object)XSModelGroup.SEQUENCE, (Object)pGroup.getCompositor());
    }

    protected void assertChoice(XSGroup pGroup) {
        ParserTestBase.assertFalse((boolean)pGroup.isSequence());
        ParserTestBase.assertTrue((boolean)pGroup.isChoice());
        ParserTestBase.assertFalse((boolean)pGroup.isAll());
        ParserTestBase.assertEquals((Object)XSModelGroup.CHOICE, (Object)pGroup.getCompositor());
    }

    protected XSElement assertElement(XSParticle pParticle) {
        ParserTestBase.assertTrue((boolean)pParticle.isElement());
        ParserTestBase.assertEquals((Object)XSParticle.ELEMENT, (Object)pParticle.getType());
        XSElement result = pParticle.getElement();
        ParserTestBase.assertNotNull((Object)result);
        return result;
    }

    protected XSSimpleContentType assertSimpleContent(XSComplexType pType) {
        ParserTestBase.assertTrue((boolean)pType.hasSimpleContent());
        XSSimpleContentType result = pType.getSimpleContent();
        ParserTestBase.assertNotNull((Object)result);
        XSType resultType = result.getType();
        ParserTestBase.assertNotNull((Object)resultType);
        ParserTestBase.assertTrue((boolean)resultType.isSimple());
        boolean haveException = false;
        try {
            pType.getComplexContentType();
        }
        catch (IllegalStateException e) {
            haveException = true;
        }
        ParserTestBase.assertTrue((boolean)haveException);
        ParserTestBase.assertNotNull((Object)result);
        return result;
    }
}

