/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.CallbackLookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDocInfo {
    private Document doc = null;
    private Crypto crypto = null;
    private List<Element> tokenList = null;
    private List<Element> elementList = null;
    private List<WSSecurityEngineResult> resultsList = null;
    private CallbackLookup callbackLookup = null;

    public WSDocInfo(Document doc) {
        this.doc = doc.getDocumentElement().getOwnerDocument();
    }

    public void clear() {
        this.crypto = null;
        if (this.tokenList != null && this.tokenList.size() > 0) {
            this.tokenList.clear();
        }
        if (this.elementList != null && this.elementList.size() > 0) {
            this.elementList.clear();
        }
        if (this.resultsList != null && this.resultsList.size() > 0) {
            this.resultsList.clear();
        }
        this.tokenList = null;
        this.elementList = null;
        this.resultsList = null;
    }

    public void addTokenElement(Element elem) {
        if (this.tokenList == null) {
            this.tokenList = new ArrayList<Element>();
        }
        this.tokenList.add(elem);
    }

    public Element getTokenElement(String uri) {
        String id = uri;
        if (id == null) {
            return null;
        }
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        if (this.tokenList != null) {
            for (Element elem : this.tokenList) {
                String cId = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                String samlId = elem.getAttribute("AssertionID");
                String samlId2 = elem.getAttribute("ID");
                if (!id.equals(cId) && !id.equals(samlId) && !id.equals(samlId2)) continue;
                return elem;
            }
        }
        return null;
    }

    public void addProtectionElement(Element element) {
        if (this.elementList == null) {
            this.elementList = new ArrayList<Element>();
        }
        this.elementList.add(element);
    }

    public Element getProtectionElement(String uri) {
        String id = uri;
        if (id == null) {
            return null;
        }
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        if (this.elementList != null) {
            for (Element element : this.elementList) {
                String cId;
                if (element == null || !id.equals(cId = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"))) continue;
                return element;
            }
        }
        return null;
    }

    public void addResult(WSSecurityEngineResult result) {
        if (this.resultsList == null) {
            this.resultsList = new ArrayList<WSSecurityEngineResult>();
        }
        this.resultsList.add(result);
    }

    public WSSecurityEngineResult getResult(String uri) {
        String id = uri;
        if (id == null) {
            return null;
        }
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        if (this.resultsList != null) {
            for (WSSecurityEngineResult result : this.resultsList) {
                String cId;
                if (result == null || !id.equals(cId = (String)result.get("id"))) continue;
                return result;
            }
        }
        return null;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setCrypto(Crypto crypto) {
        this.crypto = crypto;
    }

    public void setCallbackLookup(CallbackLookup callbackLookup) {
        this.callbackLookup = callbackLookup;
    }

    public CallbackLookup getCallbackLookup() {
        return this.callbackLookup;
    }
}

