/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedDataProcessor
implements Processor {
    private static Log log = LogFactory.getLog(EncryptedDataProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData request, WSDocInfo wsDocInfo) throws WSSecurityException {
        Element kiElem;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found EncryptedData element");
        }
        if ((kiElem = WSSecurityUtil.getDirectChildElement(elem, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#")) == null) {
            throw new WSSecurityException(2, "noKeyinfo");
        }
        String symEncAlgo = X509Util.getEncAlgo(elem);
        Element encryptedKeyElement = WSSecurityUtil.getDirectChildElement(kiElem, "EncryptedKey", "http://www.w3.org/2001/04/xmlenc#");
        if (encryptedKeyElement == null) {
            throw new WSSecurityException(2, "noEncKey");
        }
        EncryptedKeyProcessor encrKeyProc = new EncryptedKeyProcessor();
        List<WSSecurityEngineResult> encrKeyResults = encrKeyProc.handleToken(encryptedKeyElement, request, wsDocInfo);
        byte[] symmKey = (byte[])encrKeyResults.get(0).get("secret");
        SecretKey key = WSSecurityUtil.prepareSecretKey(symEncAlgo, symmKey);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
            xmlCipher.init(2, (Key)key);
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(2, null, null, ex);
        }
        Node previousSibling = elem.getPreviousSibling();
        Node parent = elem.getParentNode();
        try {
            xmlCipher.doFinal(elem.getOwnerDocument(), elem, false);
        }
        catch (Exception e) {
            throw new WSSecurityException(6, null, null, e);
        }
        WSSConfig wssConfig = request.getWssConfig();
        if (wssConfig != null) {
            Element decryptedElem = previousSibling == null ? (Element)parent.getFirstChild() : (Element)previousSibling.getNextSibling();
            QName el = new QName(decryptedElem.getNamespaceURI(), decryptedElem.getLocalName());
            Processor proc = request.getWssConfig().getProcessor(el);
            if (proc != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Processing decrypted element with: " + proc.getClass().getName()));
                }
                List<WSSecurityEngineResult> results = proc.handleToken(decryptedElem, request, wsDocInfo);
                ArrayList<WSSecurityEngineResult> completeResults = new ArrayList<WSSecurityEngineResult>();
                completeResults.addAll(encrKeyResults);
                completeResults.addAll(0, results);
                return completeResults;
            }
        }
        return encrKeyResults;
    }
}

