/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.action;

import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.crypto.dsig.Reference;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.message.WSSecSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureAction
implements Action {
    public void execute(WSHandler handler, int actionToDo, Document doc, RequestData reqData) throws WSSecurityException {
        CallbackHandler callbackHandler = handler.getPasswordCallbackHandler(reqData);
        WSPasswordCallback passwordCallback = handler.getPasswordCB(reqData.getSignatureUser(), actionToDo, callbackHandler, reqData);
        WSSecSignature wsSign = new WSSecSignature(reqData.getWssConfig());
        if (reqData.getSigKeyId() != 0) {
            wsSign.setKeyIdentifierType(reqData.getSigKeyId());
        }
        if (reqData.getSigAlgorithm() != null) {
            wsSign.setSignatureAlgorithm(reqData.getSigAlgorithm());
        }
        if (reqData.getSigDigestAlgorithm() != null) {
            wsSign.setDigestAlgo(reqData.getSigDigestAlgorithm());
        }
        if (reqData.getSignatureC14nAlgorithm() != null) {
            wsSign.setSigCanonicalization(reqData.getSignatureC14nAlgorithm());
        }
        wsSign.setUserInfo(reqData.getSignatureUser(), passwordCallback.getPassword());
        wsSign.setUseSingleCertificate(reqData.isUseSingleCert());
        if (reqData.getSignatureParts().size() > 0) {
            wsSign.setParts(reqData.getSignatureParts());
        }
        if (passwordCallback.getKey() != null) {
            wsSign.setSecretKey(passwordCallback.getKey());
        }
        try {
            wsSign.prepare(doc, reqData.getSigCrypto(), reqData.getSecHeader());
            Element siblingElementToPrepend = null;
            boolean signBST = false;
            for (WSEncryptionPart part : reqData.getSignatureParts()) {
                if ("STRTransform".equals(part.getName()) && part.getId() == null) {
                    part.setId(wsSign.getSecurityTokenReferenceURI());
                    continue;
                }
                if (reqData.isAppendSignatureAfterTimestamp() && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(part.getNamespace()) && "Timestamp".equals(part.getName())) {
                    int originalSignatureActionIndex = reqData.getOriginalSignatureActionPosition();
                    if (originalSignatureActionIndex <= 0) continue;
                    Element secHeader = reqData.getSecHeader().getSecurityHeader();
                    Node lastChild = secHeader.getLastChild();
                    for (int count = 0; lastChild != null && count < originalSignatureActionIndex; ++count) {
                        while (lastChild != null && lastChild.getNodeType() != 1) {
                            lastChild = lastChild.getPreviousSibling();
                        }
                    }
                    if (!(lastChild instanceof Element)) continue;
                    siblingElementToPrepend = (Element)lastChild;
                    continue;
                }
                if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(part.getNamespace()) || !"BinarySecurityToken".equals(part.getName())) continue;
                signBST = true;
            }
            if (signBST) {
                wsSign.prependBSTElementToHeader(reqData.getSecHeader());
            }
            List<Reference> referenceList = wsSign.addReferencesToSign(reqData.getSignatureParts(), reqData.getSecHeader());
            if (signBST || reqData.isAppendSignatureAfterTimestamp() && siblingElementToPrepend == null) {
                wsSign.computeSignature(referenceList, false, null);
            } else {
                wsSign.computeSignature(referenceList, true, siblingElementToPrepend);
            }
            if (!signBST) {
                wsSign.prependBSTElementToHeader(reqData.getSecHeader());
            }
            reqData.getSignatureValues().add(wsSign.getSignatureValue());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("Error during Signature: ", e);
        }
    }
}

