/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.DOMX509Data;
import org.apache.ws.security.message.token.DOMX509IssuerSerial;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.UUIDGenerator;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.JCEMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WSSecEncryptedKey
extends WSSecBase {
    private static Log log = LogFactory.getLog(WSSecEncryptedKey.class);
    protected Document document;
    protected Element envelope = null;
    protected byte[] ephemeralKey;
    protected SecretKey symmetricKey = null;
    protected byte[] encryptedEphemeralKey;
    protected String encrUser = null;
    protected String keyEncAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    protected String symEncAlgo = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    protected Element encryptedKeyElement = null;
    protected String encKeyId = null;
    protected String customEKTokenValueType;
    protected String customEKTokenId;
    protected BinarySecurity bstToken = null;
    protected X509Certificate useThisCert = null;

    public WSSecEncryptedKey() {
    }

    public WSSecEncryptedKey(WSSConfig config) {
        super(config);
    }

    public void setUserInfo(String user) {
        this.user = user;
    }

    public String getId() {
        return this.encKeyId;
    }

    public void prepare(Document doc, Crypto crypto) throws WSSecurityException {
        X509Certificate remoteCert;
        this.document = doc;
        if (this.ephemeralKey == null) {
            if (this.symmetricKey == null) {
                KeyGenerator keyGen = this.getKeyGenerator();
                this.symmetricKey = keyGen.generateKey();
            }
            this.ephemeralKey = this.symmetricKey.getEncoded();
        }
        if (this.symmetricKey == null) {
            this.symmetricKey = WSSecurityUtil.prepareSecretKey(this.symEncAlgo, this.ephemeralKey);
        }
        if ((remoteCert = this.useThisCert) == null) {
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias(this.user);
            X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
            if (certs == null || certs.length <= 0) {
                throw new WSSecurityException(0, "noUserCertsFound", new Object[]{this.user, "encryption"});
            }
            remoteCert = certs[0];
        }
        this.prepareInternal(this.symmetricKey, remoteCert, crypto);
    }

    protected void prepareInternal(SecretKey secretKey, X509Certificate remoteCert, Crypto crypto) throws WSSecurityException {
        Cipher cipher = WSSecurityUtil.getCipherInstance(this.keyEncAlgo);
        try {
            cipher.init(3, remoteCert);
        }
        catch (InvalidKeyException e) {
            throw new WSSecurityException(9, null, null, e);
        }
        int blockSize = cipher.getBlockSize();
        if (this.doDebug) {
            log.debug((Object)("cipher blksize: " + blockSize + ", symm key: " + secretKey.toString()));
        }
        try {
            this.encryptedEphemeralKey = cipher.wrap(secretKey);
        }
        catch (IllegalStateException ex) {
            throw new WSSecurityException(9, null, null, ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new WSSecurityException(9, null, null, ex);
        }
        catch (InvalidKeyException ex) {
            throw new WSSecurityException(9, null, null, ex);
        }
        Text keyText = WSSecurityUtil.createBase64EncodedTextNode(this.document, this.encryptedEphemeralKey);
        this.encryptedKeyElement = this.createEncryptedKey(this.document, this.keyEncAlgo);
        if (this.encKeyId == null || "".equals(this.encKeyId)) {
            this.encKeyId = "EK-" + UUIDGenerator.getUUID();
        }
        this.encryptedKeyElement.setAttributeNS(null, "Id", this.encKeyId);
        SecurityTokenReference secToken = new SecurityTokenReference(this.document);
        switch (this.keyIdentifierType) {
            case 3: {
                secToken.setKeyIdentifier(remoteCert);
                break;
            }
            case 4: {
                secToken.setKeyIdentifierSKI(remoteCert, crypto);
                break;
            }
            case 8: {
                secToken.setKeyIdentifierThumb(remoteCert);
                break;
            }
            case 10: {
                secToken.setKeyIdentifierThumb(remoteCert);
                break;
            }
            case 2: {
                String issuer = remoteCert.getIssuerX500Principal().getName();
                BigInteger serialNumber = remoteCert.getSerialNumber();
                DOMX509IssuerSerial domIssuerSerial = new DOMX509IssuerSerial(this.document, issuer, serialNumber);
                DOMX509Data domX509Data = new DOMX509Data(this.document, domIssuerSerial);
                secToken.setX509Data(domX509Data);
                break;
            }
            case 1: {
                Reference ref = new Reference(this.document);
                String certUri = UUIDGenerator.getUUID();
                ref.setURI("#" + certUri);
                this.bstToken = new X509Security(this.document);
                ((X509Security)this.bstToken).setX509Certificate(remoteCert);
                this.bstToken.setID(certUri);
                ref.setValueType(this.bstToken.getValueType());
                secToken.setReference(ref);
                break;
            }
            case 9: {
                Reference refCust = new Reference(this.document);
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.customEKTokenValueType)) {
                    secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                    refCust.setValueType(this.customEKTokenValueType);
                } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(this.customEKTokenValueType)) {
                    secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                } else if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(this.customEKTokenValueType)) {
                    secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    refCust.setValueType(this.customEKTokenValueType);
                } else {
                    refCust.setValueType(this.customEKTokenValueType);
                }
                refCust.setURI("#" + this.customEKTokenId);
                secToken.setReference(refCust);
                break;
            }
            case 11: {
                Reference refCustd = new Reference(this.document);
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.customEKTokenValueType)) {
                    secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                    refCustd.setValueType(this.customEKTokenValueType);
                } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(this.customEKTokenValueType)) {
                    secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                } else if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(this.customEKTokenValueType)) {
                    secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    refCustd.setValueType(this.customEKTokenValueType);
                } else {
                    refCustd.setValueType(this.customEKTokenValueType);
                }
                refCustd.setURI(this.customEKTokenId);
                secToken.setReference(refCustd);
                break;
            }
            case 12: {
                secToken.setKeyIdentifier(this.customEKTokenValueType, this.customEKTokenId);
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.customEKTokenValueType)) {
                    secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                    break;
                }
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(this.customEKTokenValueType)) {
                    secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                    break;
                }
                if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(this.customEKTokenValueType)) {
                    secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    break;
                }
                if (!"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(this.customEKTokenValueType)) break;
                secToken.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                break;
            }
            default: {
                throw new WSSecurityException(0, "unsupportedKeyId");
            }
        }
        Element keyInfoElement = this.document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        keyInfoElement.appendChild(secToken.getElement());
        this.encryptedKeyElement.appendChild(keyInfoElement);
        Element xencCipherValue = this.createCipherValue(this.document, this.encryptedKeyElement);
        xencCipherValue.appendChild(keyText);
        this.envelope = this.document.getDocumentElement();
    }

    protected KeyGenerator getKeyGenerator() throws WSSecurityException {
        try {
            String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)this.symEncAlgo);
            if (keyAlgorithm == null || "".equals(keyAlgorithm)) {
                keyAlgorithm = JCEMapper.translateURItoJCEID((String)this.symEncAlgo);
            }
            KeyGenerator keyGen = KeyGenerator.getInstance(keyAlgorithm);
            if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes128-gcm")) {
                keyGen.init(128);
            } else if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                keyGen.init(192);
            } else if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc") || this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes256-gcm")) {
                keyGen.init(256);
            }
            return keyGen;
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(2, null, null, e);
        }
    }

    protected Element createEncryptedKey(Document doc, String keyTransportAlgo) {
        Element encryptedKey = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptedKey");
        WSSecurityUtil.setNamespace(encryptedKey, "http://www.w3.org/2001/04/xmlenc#", "xenc");
        Element encryptionMethod = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptionMethod");
        encryptionMethod.setAttributeNS(null, "Algorithm", keyTransportAlgo);
        encryptedKey.appendChild(encryptionMethod);
        return encryptedKey;
    }

    protected Element createCipherValue(Document doc, Element encryptedKey) {
        Element cipherData = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherData");
        Element cipherValue = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherValue");
        cipherData.appendChild(cipherValue);
        encryptedKey.appendChild(cipherData);
        return cipherValue;
    }

    public void prependToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.encryptedKeyElement);
    }

    public void appendToHeader(WSSecHeader secHeader) {
        Element secHeaderElement = secHeader.getSecurityHeader();
        secHeaderElement.appendChild(this.encryptedKeyElement);
    }

    public void prependBSTElementToHeader(WSSecHeader secHeader) {
        if (this.bstToken != null) {
            WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.bstToken.getElement());
        }
        this.bstToken = null;
    }

    public void appendBSTElementToHeader(WSSecHeader secHeader) {
        if (this.bstToken != null) {
            Element secHeaderElement = secHeader.getSecurityHeader();
            secHeaderElement.appendChild(this.bstToken.getElement());
        }
        this.bstToken = null;
    }

    public byte[] getEphemeralKey() {
        return this.ephemeralKey;
    }

    public void setUseThisCert(X509Certificate cert) {
        this.useThisCert = cert;
    }

    public Element getEncryptedKeyElement() {
        return this.encryptedKeyElement;
    }

    public void setEncryptedKeyElement(Element encryptedKeyElement) {
        this.encryptedKeyElement = encryptedKeyElement;
    }

    public Element getBinarySecurityTokenElement() {
        if (this.bstToken != null) {
            return this.bstToken.getElement();
        }
        return null;
    }

    public void setKeyEncAlgo(String keyEncAlgo) {
        this.keyEncAlgo = keyEncAlgo;
    }

    public void setEphemeralKey(byte[] ephemeralKey) {
        this.ephemeralKey = ephemeralKey;
    }

    public String getBSTTokenId() {
        if (this.bstToken == null) {
            return null;
        }
        return this.bstToken.getID();
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setEncKeyId(String encKeyId) {
        this.encKeyId = encKeyId;
    }

    public boolean isCertSet() {
        return this.useThisCert == null;
    }

    public byte[] getEncryptedEphemeralKey() {
        return this.encryptedEphemeralKey;
    }

    public void setCustomEKTokenValueType(String customEKTokenValueType) {
        this.customEKTokenValueType = customEKTokenValueType;
    }

    public void setCustomEKTokenId(String customEKTokenId) {
        this.customEKTokenId = customEKTokenId;
    }

    public void setSymmetricEncAlgorithm(String algo) {
        this.symEncAlgo = algo;
    }

    public String getSymmetricEncAlgorithm() {
        return this.symEncAlgo;
    }

    public SecretKey getSymmetricKey() {
        return this.symmetricKey;
    }

    public void setSymmetricKey(SecretKey key) {
        this.symmetricKey = key;
    }
}

