/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.crypto;

import java.util.ArrayList;
import java.util.List;
import org.apache.wss4j.common.util.RFC2253Parser;

public class X509NameTokenizer {
    private final List<String> tokens = new ArrayList<String>();
    private int index = 0;

    public X509NameTokenizer(String dn) {
        int k;
        String normalizedDN = RFC2253Parser.normalize(dn);
        int i = 0;
        int l = 0;
        int j = 0;
        while ((k = normalizedDN.indexOf(44, j)) >= 0) {
            if (k > 0 && normalizedDN.charAt(k - 1) != '\\' && (l += X509NameTokenizer.countQuotes(normalizedDN, j, k)) % 2 == 0) {
                this.tokens.add(normalizedDN.substring(i, k).trim());
                i = k + 1;
                l = 0;
            }
            j = k + 1;
        }
        if (normalizedDN.trim().length() != 0) {
            this.tokens.add(X509NameTokenizer.trim(normalizedDN.substring(i)));
        }
    }

    public boolean hasMoreTokens() {
        return this.index < this.tokens.size();
    }

    public String nextToken() {
        if (this.hasMoreTokens()) {
            return this.tokens.get(this.index++);
        }
        return "";
    }

    private static int countQuotes(String s, int i, int j) {
        int k = 0;
        for (int l = i; l < j; ++l) {
            if (s.charAt(l) != '\"') continue;
            ++k;
        }
        return k;
    }

    private static String trim(String str) {
        String trimed = str.trim();
        int i = str.indexOf(trimed) + trimed.length();
        if (str.length() > i && trimed.endsWith("\\") && !trimed.endsWith("\\\\") && str.charAt(i) == ' ') {
            trimed = trimed + " ";
        }
        return trimed;
    }
}

