/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.osgi.bundle.util.BundleClassFinder;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.apache.xbean.osgi.bundle.util.ClassDiscoveryFilter;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleAssignableClassFinder
extends BundleClassFinder {
    private static final Logger logger = LoggerFactory.getLogger(BundleAssignableClassFinder.class);
    private Class<?>[] clses;
    private Set<String> targetClassNames = new HashSet<String>();
    private Set<String> targetInterfaceNames = new HashSet<String>();
    private Set<String> wiredImportedPackageNames = new HashSet<String>();

    public BundleAssignableClassFinder(PackageAdmin packageAdmin, Bundle bundle, Class<?>[] clses, ClassDiscoveryFilter discoveryFilter) {
        super(packageAdmin, bundle, discoveryFilter);
        if (clses == null || clses.length == 0) {
            throw new IllegalArgumentException("At least one class or interface should be specified");
        }
        this.clses = clses;
        for (Class<?> cls : clses) {
            String asmStyleName = cls.getName().replace('.', '/');
            if (cls.isInterface()) {
                this.targetInterfaceNames.add(asmStyleName);
                continue;
            }
            this.targetClassNames.add(asmStyleName);
        }
        this.initialize();
    }

    public BundleAssignableClassFinder(PackageAdmin packageAdmin, Class<?>[] clses, Bundle bundle) {
        this(packageAdmin, bundle, clses, FULL_CLASS_DISCOVERY_FILTER);
    }

    protected BundleClassFinder createSubBundleClassFinder(PackageAdmin packageAdmin, Bundle bundle, ClassDiscoveryFilter classDiscoveryFilter) {
        return new BundleAssignableClassFinder(packageAdmin, bundle, this.clses, classDiscoveryFilter);
    }

    protected boolean isClassAcceptable(String name, InputStream in) throws IOException {
        ClassReader classReader = new ClassReader(in);
        String className = classReader.getClassName();
        if ((classReader.getAccess() & 0x200) == 0 ? this.targetClassNames.contains(className) : this.targetInterfaceNames.contains(className)) {
            return true;
        }
        String[] interfaceNames = classReader.getInterfaces();
        try {
            for (String interfaceName : interfaceNames) {
                if (this.wiredImportedPackageNames.contains(this.toASMStylePackageName(interfaceName))) {
                    return this.isClassAssignable(this.bundle.loadClass(this.toJavaStyleClassName(interfaceName)));
                }
                if (!this.isInterfaceAssignable(interfaceName)) continue;
                return true;
            }
            String superClassName = classReader.getSuperName();
            if (this.wiredImportedPackageNames.contains(this.toASMStylePackageName(superClassName))) {
                return this.isClassAssignable(this.bundle.loadClass(this.toJavaStyleClassName(superClassName)));
            }
            return this.isSuperClassAssignable(superClassName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClassAcceptable(URL url) {
        InputStream in = null;
        try {
            in = url.openStream();
            boolean bl = this.isClassAcceptable("", in);
            return bl;
        }
        catch (IOException e) {
            logger.warn("Unable to check the class of url " + url, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void initialize() {
        BundleDescription description = new BundleDescription(this.bundle.getHeaders());
        List imports = description.getExternalImports();
        for (BundleDescription.ImportPackage packageImport : imports) {
            String packageName = packageImport.getName();
            ExportedPackage[] exports = this.packageAdmin.getExportedPackages(packageName);
            Bundle wiredBundle = this.isWired(this.bundle, exports);
            if (wiredBundle == null) continue;
            this.wiredImportedPackageNames.add(packageName.replace('.', '/'));
            break;
        }
    }

    private boolean isClassAssignable(Class<?> cls) {
        for (Class<?> targetClass : this.clses) {
            if (!targetClass.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInterfaceAssignable(String interfaceName) {
        if (this.targetInterfaceNames.contains(interfaceName)) {
            return true;
        }
        URL url = this.bundle.getResource(interfaceName + ".class");
        if (url == null) {
            return false;
        }
        InputStream in = null;
        try {
            String[] superInterfaceNames;
            in = url.openStream();
            ClassReader classReader = new ClassReader(in);
            for (String superInterfaceName : superInterfaceNames = classReader.getInterfaces()) {
                if (!this.isInterfaceAssignable(superInterfaceName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.warn("Unable to check the interface " + interfaceName, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSuperClassAssignable(String superClassName) {
        if (this.targetClassNames.contains(superClassName)) {
            return true;
        }
        if (superClassName.equals("java/lang/Object")) {
            return false;
        }
        URL url = this.bundle.getResource(superClassName + ".class");
        if (url == null) {
            return false;
        }
        InputStream in = null;
        try {
            String[] superInterfaceNames;
            in = url.openStream();
            ClassReader classReader = new ClassReader(in);
            for (String superInterfaceName : superInterfaceNames = classReader.getInterfaces()) {
                if (!this.isInterfaceAssignable(superInterfaceName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = this.isSuperClassAssignable(classReader.getSuperName());
            return bl;
        }
        catch (IOException e) {
            logger.warn("Unable to check the super class  " + superClassName, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String toASMStylePackageName(String className) {
        int iLastDotIndex;
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - ".class".length());
        }
        if ((iLastDotIndex = (className = className.replace('.', '/')).lastIndexOf(47)) != -1) {
            return className.substring(0, iLastDotIndex);
        }
        return "";
    }
}

