/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.interrupt.InterruptInquiryExecutionPlan;
import org.apereo.cas.interrupt.webflow.InterruptSingleSignOnParticipationStrategy;
import org.apereo.cas.interrupt.webflow.InterruptWebflowConfigurer;
import org.apereo.cas.interrupt.webflow.actions.FinalizeInterruptFlowAction;
import org.apereo.cas.interrupt.webflow.actions.InquireInterruptAction;
import org.apereo.cas.interrupt.webflow.actions.PrepareInterruptViewAction;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategyConfigurer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="casInterruptWebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasInterruptWebflowConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="interruptInquirer")
    private ObjectProvider<InterruptInquiryExecutionPlan> interruptInquirer;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    @ConditionalOnMissingBean(name={"interruptWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer interruptWebflowConfigurer() {
        return new InterruptWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.applicationContext, this.casProperties);
    }

    @ConditionalOnMissingBean(name={"inquireInterruptAction"})
    @Bean
    @RefreshScope
    public Action inquireInterruptAction() {
        return new InquireInterruptAction(((InterruptInquiryExecutionPlan)this.interruptInquirer.getObject()).getInterruptInquirers());
    }

    @ConditionalOnMissingBean(name={"prepareInterruptViewAction"})
    @Bean
    @RefreshScope
    public Action prepareInterruptViewAction() {
        return new PrepareInterruptViewAction();
    }

    @ConditionalOnMissingBean(name={"finalizeInterruptFlowAction"})
    @Bean
    @RefreshScope
    public Action finalizeInterruptFlowAction() {
        return new FinalizeInterruptFlowAction();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"interruptSingleSignOnParticipationStrategy"})
    public SingleSignOnParticipationStrategy interruptSingleSignOnParticipationStrategy() {
        return new InterruptSingleSignOnParticipationStrategy();
    }

    @Bean
    @ConditionalOnMissingBean(name={"interruptSingleSignOnParticipationStrategyConfigurer"})
    @RefreshScope
    public SingleSignOnParticipationStrategyConfigurer interruptSingleSignOnParticipationStrategyConfigurer() {
        return chain -> chain.addStrategy(this.interruptSingleSignOnParticipationStrategy());
    }

    @Bean
    @ConditionalOnMissingBean(name={"interruptCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer interruptCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.interruptWebflowConfigurer());
    }
}

