/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.interrupt.webflow;

import java.util.Map;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.EvaluateAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.SubflowState;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class InterruptWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    static final String INTERRUPT_VIEW = "casInterruptView";
    static final String VIEW_ID_INTERRUPT_VIEW = "interruptView";
    static final String STATE_ID_INQUIRE_INTERRUPT_ACTION = "inquireInterruptAction";
    static final String STATE_ID_FINALIZE_INTERRUPT_ACTION = "finalizeInterruptFlowAction";
    static final String STATE_ID_FINISHED_INTERRUPT = "finishedInterrupt";
    static final String ACTION_ID_PREPARE_INTERRUPT_VIEW = "prepareInterruptViewAction";

    public InterruptWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createInquireActionState(flow);
            this.createInterruptView(flow);
            this.createTransitionStateToInterrupt(flow);
            this.createTransitionStateForMultifactorSubflows(flow);
            this.createTransitionStateForAuthenticationWarnings(flow);
        }
    }

    private void createTransitionStateForAuthenticationWarnings(Flow flow) {
        ViewState state = (ViewState)this.getState(flow, "showAuthenticationWarningMessages", ViewState.class);
        this.createTransitionForState((TransitionableState)state, "proceed", STATE_ID_INQUIRE_INTERRUPT_ACTION, true);
    }

    private void createTransitionStateToInterrupt(Flow flow) {
        ActionState submit = this.getRealSubmissionState(flow);
        this.createTransitionForState((TransitionableState)submit, "success", STATE_ID_INQUIRE_INTERRUPT_ACTION, true);
        ActionState ticketCreateState = (ActionState)this.getState(flow, "createTicketGrantingTicket", ActionState.class);
        this.prependActionsToActionStateExecutionList(flow, ticketCreateState, new EvaluateAction[]{this.getInquireInterruptAction()});
        this.createTransitionForState((TransitionableState)ticketCreateState, "interruptRequired", VIEW_ID_INTERRUPT_VIEW);
    }

    private void createTransitionStateForMultifactorSubflows(Flow flow) {
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        providerMap.forEach((k, v) -> {
            if (this.containsSubflowState(flow, v.getId())) {
                SubflowState state = (SubflowState)this.getState(flow, v.getId(), SubflowState.class);
                this.createTransitionForState((TransitionableState)state, "success", STATE_ID_INQUIRE_INTERRUPT_ACTION, true);
            }
        });
    }

    private ActionState getRealSubmissionState(Flow flow) {
        return (ActionState)this.getState(flow, "realSubmit", ActionState.class);
    }

    private void createInterruptView(Flow flow) {
        ViewState viewState = this.createViewState(flow, VIEW_ID_INTERRUPT_VIEW, INTERRUPT_VIEW);
        viewState.getEntryActionList().add((Action)this.createEvaluateAction(ACTION_ID_PREPARE_INTERRUPT_VIEW));
        this.createStateDefaultTransition((TransitionableState)viewState, STATE_ID_FINALIZE_INTERRUPT_ACTION);
        String target = this.getRealSubmissionState(flow).getTransition("success").getTargetStateId();
        ActionState finalizeInterrupt = this.createActionState(flow, STATE_ID_FINALIZE_INTERRUPT_ACTION, (Action)this.createEvaluateAction(STATE_ID_FINALIZE_INTERRUPT_ACTION));
        this.createTransitionForState((TransitionableState)finalizeInterrupt, "success", target);
        this.createTransitionForState((TransitionableState)finalizeInterrupt, "stop", STATE_ID_FINISHED_INTERRUPT);
        this.createEndState(flow, STATE_ID_FINISHED_INTERRUPT);
    }

    private void createInquireActionState(Flow flow) {
        ActionState inquireState = this.createActionState(flow, STATE_ID_INQUIRE_INTERRUPT_ACTION, (Action)this.getInquireInterruptAction());
        String target = this.getRealSubmissionState(flow).getTransition("success").getTargetStateId();
        Transition noInterruptTransition = this.createTransition("interruptSkipped", target);
        TransitionSet transitionSet = inquireState.getTransitionSet();
        transitionSet.add(noInterruptTransition);
        Transition yesInterruptTransition = this.createTransition("interruptRequired", VIEW_ID_INTERRUPT_VIEW);
        transitionSet.add(yesInterruptTransition);
    }

    private EvaluateAction getInquireInterruptAction() {
        return this.createEvaluateAction(STATE_ID_INQUIRE_INTERRUPT_ACTION);
    }
}

