/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.interrupt.webflow.actions;

import java.net.URI;
import java.util.Optional;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.interrupt.InterruptResponse;
import org.apereo.cas.interrupt.webflow.InterruptUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class FinalizeInterruptFlowAction
extends AbstractAction {
    protected Event doExecute(RequestContext requestContext) throws Exception {
        InterruptResponse response = InterruptUtils.getInterruptFrom(requestContext);
        if (response.isBlock()) {
            RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
            URI accessUrl = Optional.ofNullable(registeredService).map(service -> service.getAccessStrategy().getUnauthorizedRedirectUrl()).orElse(null);
            if (accessUrl != null) {
                String url = accessUrl.toURL().toExternalForm();
                ExternalContext externalContext = requestContext.getExternalContext();
                externalContext.requestExternalRedirect(url);
                externalContext.recordResponseComplete();
                return new EventFactorySupport().event((Object)this, "stop");
            }
            throw new UnauthorizedServiceException("screen.service.error.message", "Denied");
        }
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        authentication.addAttribute("finalizedInterrupt", (Object)Boolean.TRUE);
        WebUtils.putAuthentication((Authentication)authentication, (RequestContext)requestContext);
        return this.success();
    }
}

