/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.interrupt.webflow.actions;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.interrupt.InterruptInquirer;
import org.apereo.cas.interrupt.InterruptResponse;
import org.apereo.cas.interrupt.webflow.InterruptUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class InquireInterruptAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InquireInterruptAction.class);
    public static final String AUTHENTICATION_ATTRIBUTE_FINALIZED_INTERRUPT = "finalizedInterrupt";
    private final List<InterruptInquirer> interruptInquirers;

    protected Event doExecute(RequestContext requestContext) {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
        Credential credential = WebUtils.getCredential((RequestContext)requestContext);
        EventFactorySupport eventFactorySupport = new EventFactorySupport();
        if (authentication.getAttributes().containsKey(AUTHENTICATION_ATTRIBUTE_FINALIZED_INTERRUPT)) {
            LOGGER.debug("Authentication event has already finalized interrupt. Skipping...");
            return this.getInterruptSkippedEvent();
        }
        for (InterruptInquirer inquirer : this.interruptInquirers) {
            LOGGER.debug("Invoking interrupt inquirer using [{}]", (Object)inquirer.getName());
            InterruptResponse response = inquirer.inquire(authentication, registeredService, (Service)service, credential, requestContext);
            if (response == null || !response.isInterrupt()) continue;
            LOGGER.debug("Interrupt inquiry is required since inquirer produced a response [{}]", (Object)response);
            InterruptUtils.putInterruptIn(requestContext, response);
            WebUtils.putPrincipal((RequestContext)requestContext, (Principal)authentication.getPrincipal());
            return eventFactorySupport.event((Object)this, "interruptRequired");
        }
        LOGGER.debug("Webflow interrupt is skipped since no inquirer produced a response");
        return this.getInterruptSkippedEvent();
    }

    private Event getInterruptSkippedEvent() {
        return new EventFactorySupport().event((Object)this, "interruptSkipped");
    }

    @Generated
    public InquireInterruptAction(List<InterruptInquirer> interruptInquirers) {
        this.interruptInquirers = interruptInquirers;
    }
}

