/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.config.CasOidcAutoConfiguration;
import org.apereo.cas.config.CasTokenCoreAutoConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.token.TokenAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.token.authentication.OAuth20AccessTokenAuthenticationHandler;
import org.apereo.cas.token.authentication.TokenAuthenticationHandler;
import org.apereo.cas.token.authentication.TokenAuthenticationPostProcessor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Authentication}, module="token")
@AutoConfiguration
@ImportAutoConfiguration(value={CasTokenCoreAutoConfiguration.class})
public class CasTokenAuthenticationAutoConfiguration {

    @Configuration(value="TokenOidcAuthenticationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnClass(value={CasOidcAutoConfiguration.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OpenIDConnect})
    static class TokenOidcAuthenticationConfiguration {
        TokenOidcAuthenticationConfiguration() {
        }

        @ConditionalOnMissingBean(name={"oauthAccessTokenAuthenticationHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationHandler oauthAccessTokenAuthenticationHandler(ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="tokenPrincipalFactory") PrincipalFactory tokenPrincipalFactory) {
            TokenAuthenticationProperties token = casProperties.getAuthn().getToken();
            OAuth20AccessTokenAuthenticationHandler handler = new OAuth20AccessTokenAuthenticationHandler(tokenPrincipalFactory, applicationContext, token);
            handler.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)token.getCredentialCriteria()));
            handler.setState(token.getState());
            return handler;
        }

        @ConditionalOnMissingBean(name={"oauthAccessTokenAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer oauthAccessTokenAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="oauthAccessTokenAuthenticationHandler") AuthenticationHandler oauthAccessTokenAuthenticationHandler, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
            return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(oauthAccessTokenAuthenticationHandler, defaultPrincipalResolver);
        }
    }

    @Configuration(value="TokenAuthenticationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class TokenAuthenticationConfiguration {
        TokenAuthenticationConfiguration() {
        }

        @ConditionalOnMissingBean(name={"tokenPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory tokenPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }

        @ConditionalOnMissingBean(name={"tokenAuthenticationHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationHandler tokenAuthenticationHandler(@Qualifier(value="tokenCipherExecutor") CipherExecutor tokenCipherExecutor, CasConfigurationProperties casProperties, @Qualifier(value="tokenPrincipalFactory") PrincipalFactory tokenPrincipalFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            TokenAuthenticationProperties token = casProperties.getAuthn().getToken();
            TokenAuthenticationHandler handler = new TokenAuthenticationHandler(servicesManager, tokenPrincipalFactory, token);
            handler.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)token.getCredentialCriteria()));
            handler.setState(token.getState());
            return handler;
        }

        @ConditionalOnMissingBean(name={"tokenAuthenticationPostProcessor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationPostProcessor tokenAuthenticationPostProcessor(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) {
            return casProperties.getAuthn().getToken().isSsoTokenEnabled() ? new TokenAuthenticationPostProcessor(servicesManager, registeredServiceAccessStrategyEnforcer) : AuthenticationPostProcessor.none();
        }

        @ConditionalOnMissingBean(name={"tokenAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer tokenAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="tokenAuthenticationPostProcessor") AuthenticationPostProcessor tokenAuthenticationPostProcessor, @Qualifier(value="tokenAuthenticationHandler") AuthenticationHandler tokenAuthenticationHandler, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
            return plan -> {
                plan.registerAuthenticationHandlerWithPrincipalResolver(tokenAuthenticationHandler, defaultPrincipalResolver);
                plan.registerAuthenticationPostProcessor(tokenAuthenticationPostProcessor);
            };
        }
    }
}

