/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.error.support;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apereo.inspektr.error.ErrorReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLoggingErrorReporter
implements ErrorReporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void reportError(String applicationCode, String principal, String description) {
        this.logErrorRecord(applicationCode, principal, description);
    }

    @Override
    public void reportError(String applicationCode, String principal, Throwable throwable) {
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        StringBuilder builder = new StringBuilder(512);
        builder.append("\n\t").append(throwable.toString());
        for (StackTraceElement element : stackTraceElements) {
            builder.append("\n\tat ").append(element.toString());
        }
        this.logErrorRecord(applicationCode, principal, builder.toString());
    }

    private void logErrorRecord(String applicationCode, String principal, String details) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
        StringBuilder builder = new StringBuilder(512);
        builder.append("\n\n===ERROR LOG record BEGIN==========================================").append("\nAPPLICATION CODE: ").append(applicationCode).append("\nPRINCIPAL: ").append(principal).append("\nWHEN: ").append(dateTimeFormat.format(new Date())).append("\nDESCRIPTION: ").append(details).append("\n===ERROR LOG record END============================================").append("\n\n");
        this.log.error(builder.toString());
    }
}

