/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.services.persondir.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringUtils;
import org.apereo.services.persondir.IPersonAttributes;
import org.apereo.services.persondir.support.BasePersonAttributeDao;
import org.apereo.services.persondir.support.CaseInsensitiveNamedPersonImpl;
import org.apereo.services.persondir.support.NamedPersonImpl;

public class ScriptEnginePersonAttributeDao
extends BasePersonAttributeDao {
    private String scriptFile;
    private boolean caseInsensitiveUsername = false;

    public String getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(String scriptFile) {
        this.scriptFile = scriptFile;
    }

    public boolean isCaseInsensitiveUsername() {
        return this.caseInsensitiveUsername;
    }

    public void setCaseInsensitiveUsername(boolean caseInsensitiveUsername) {
        this.caseInsensitiveUsername = caseInsensitiveUsername;
    }

    public IPersonAttributes getPerson(String uid) {
        try {
            Map<String, Object> attributes = this.getScriptedAttributesFromFile(uid);
            if (this.caseInsensitiveUsername) {
                return new CaseInsensitiveNamedPersonImpl(uid, ScriptEnginePersonAttributeDao.stuffAttributesIntoListValues(attributes));
            }
            return new NamedPersonImpl(uid, ScriptEnginePersonAttributeDao.stuffAttributesIntoListValues(attributes));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Set<IPersonAttributes> getPeople(Map<String, Object> query) {
        return this.getPeopleWithMultivaluedAttributes(ScriptEnginePersonAttributeDao.stuffAttributesIntoListValues(query));
    }

    public Set<IPersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query) {
        throw new UnsupportedOperationException("This method is not implemented.");
    }

    @JsonIgnore
    public Set<String> getPossibleUserAttributeNames() {
        return Collections.EMPTY_SET;
    }

    @JsonIgnore
    public Set<String> getAvailableQueryAttributes() {
        return Collections.EMPTY_SET;
    }

    private Map<String, Object> getScriptedAttributesFromFile(String uid) throws Exception {
        String engineName = this.getScriptEngineName();
        ScriptEngine engine = new ScriptEngineManager().getEngineByName(engineName);
        if (engine == null || StringUtils.isBlank((CharSequence)engineName)) {
            this.logger.warn("Script engine is not available for [{}]", (Object)engineName);
            return new HashMap<String, Object>();
        }
        this.logger.debug("Created groovy script engine instance for [{}]", (Object)engineName);
        Object[] args = new Object[]{uid, this.logger};
        File theScriptFile = new File(this.scriptFile);
        if (theScriptFile.exists()) {
            this.logger.debug("Loading script from [{}]", (Object)theScriptFile);
            engine.eval(new FileReader(theScriptFile));
        } else {
            boolean foundStream = false;
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.scriptFile);){
                if (in != null && in.markSupported() && in.available() > 0) {
                    this.logger.debug("Loading script [{}] from classloader as a stream", (Object)theScriptFile);
                    engine.eval(new InputStreamReader(in));
                    foundStream = true;
                }
            }
            if (!foundStream) {
                this.logger.debug("Loading script [{}] in raw text format", (Object)theScriptFile);
                engine.eval(new StringReader(this.scriptFile));
            }
        }
        this.logger.debug("Executing script's run method, with parameters [{}]", args);
        Invocable invocable = (Invocable)((Object)engine);
        Map personAttributesMap = (Map)invocable.invokeFunction("run", args);
        this.logger.debug("Final set of attributes determined by the script are [{}]", (Object)personAttributesMap);
        return personAttributesMap;
    }

    private String getScriptEngineName() {
        String engineName = null;
        if (this.scriptFile.endsWith(".py")) {
            engineName = "python";
        } else if (this.scriptFile.endsWith(".js")) {
            engineName = "js";
        } else if (this.scriptFile.endsWith(".groovy")) {
            engineName = "groovy";
        }
        return engineName;
    }

    private static Map<String, List<Object>> stuffAttributesIntoListValues(Map<String, Object> personAttributesMap) {
        HashMap<String, List<Object>> personAttributes = new HashMap<String, List<Object>>();
        for (Map.Entry<String, Object> stringObjectEntry : personAttributesMap.entrySet()) {
            Object value = stringObjectEntry.getValue();
            if (value instanceof List) {
                personAttributes.put(stringObjectEntry.getKey(), (List)value);
                continue;
            }
            personAttributes.put(stringObjectEntry.getKey(), Arrays.asList(value));
        }
        return personAttributes;
    }
}

