/*
 * Decompiled with CFR 0.152.
 */
package org.appspy.perf.servlet.provider;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.appspy.core.data.CollectedData;
import org.appspy.perf.data.ServletTimerData;
import org.appspy.perf.servlet.provider.AbstractDataProvider;

public class TimerDataProvider
extends AbstractDataProvider {
    public static final String START_TIME = "startTime";
    public static final String START_BLOCK_TIME = "startBlockTime";
    public static final String START_BLOCK_COUNT = "startBlockCount";
    public static final String START_CPU_TIME = "startCPUTime";
    public static final String START_USER_CPU_TIME = "startUserCPUTime";
    public static final String START_WAIT_TIME = "startWaitTime";
    public static final String START_WAIT_COUNT = "startWaitCount";

    public void afterRequest(ServletTimerData servletTimerData, HttpServletRequest req, HttpServletResponse res, ServletContext servletContext, Throwable throwable) {
        Long initialBlockCount;
        Long initialTime = (Long)this.getAttribute((CollectedData)servletTimerData, START_TIME);
        long timerDelay = System.currentTimeMillis() - initialTime;
        servletTimerData.setTimerDelay(timerDelay);
        long threadId = Thread.currentThread().getId();
        ThreadMXBean mxb = ManagementFactory.getThreadMXBean();
        if (mxb.isThreadCpuTimeEnabled()) {
            Long initialUserCpuTime;
            Long initialCpuTime = (Long)this.getAttribute((CollectedData)servletTimerData, START_CPU_TIME);
            if (initialCpuTime != null) {
                long cpuTime = mxb.getCurrentThreadCpuTime() - initialCpuTime;
                servletTimerData.setCPUTime(cpuTime);
            }
            if ((initialUserCpuTime = (Long)this.getAttribute((CollectedData)servletTimerData, START_USER_CPU_TIME)) != null) {
                long userCpuTime = mxb.getCurrentThreadUserTime() - initialUserCpuTime;
                servletTimerData.setUserCPUTime(userCpuTime);
            }
        }
        ThreadInfo threadInfo = mxb.getThreadInfo(threadId);
        Long initialWaitCount = (Long)this.getAttribute((CollectedData)servletTimerData, START_WAIT_COUNT);
        if (initialWaitCount != null) {
            long waitCount = threadInfo.getWaitedCount() - initialWaitCount;
            servletTimerData.setWaitCount(waitCount);
        }
        if ((initialBlockCount = (Long)this.getAttribute((CollectedData)servletTimerData, START_BLOCK_COUNT)) != null) {
            long blockCount = threadInfo.getBlockedCount() - initialBlockCount;
            servletTimerData.setBlockingCount(blockCount);
        }
        if (mxb.isThreadContentionMonitoringEnabled()) {
            Long initialBlockTime;
            Long initialWaitTime = (Long)this.getAttribute((CollectedData)servletTimerData, START_WAIT_TIME);
            if (initialWaitTime != null) {
                long waitTime = threadInfo.getWaitedTime() - initialWaitTime;
                servletTimerData.setWaitDelay(waitTime);
            }
            if ((initialBlockTime = (Long)this.getAttribute((CollectedData)servletTimerData, START_BLOCK_TIME)) != null) {
                long blockTime = threadInfo.getBlockedTime() - initialBlockTime;
                servletTimerData.setBlockingDelay(blockTime);
            }
        }
    }

    public void beforeRequest(ServletTimerData servletTimerData, HttpServletRequest req, HttpServletResponse res, ServletContext servletContext) {
        servletTimerData.setCollectionDate(new Date());
        this.setAttribute((CollectedData)servletTimerData, START_TIME, System.currentTimeMillis());
        long threadId = Thread.currentThread().getId();
        ThreadMXBean mxb = ManagementFactory.getThreadMXBean();
        if (mxb.isThreadCpuTimeEnabled()) {
            long cpuTime = mxb.getCurrentThreadCpuTime();
            this.setAttribute((CollectedData)servletTimerData, START_CPU_TIME, cpuTime);
            long userCpuTime = mxb.getCurrentThreadUserTime();
            this.setAttribute((CollectedData)servletTimerData, START_USER_CPU_TIME, userCpuTime);
        }
        ThreadInfo threadInfo = mxb.getThreadInfo(threadId);
        long waitCount = threadInfo.getWaitedCount();
        this.setAttribute((CollectedData)servletTimerData, START_WAIT_COUNT, waitCount);
        long blockCount = threadInfo.getBlockedCount();
        this.setAttribute((CollectedData)servletTimerData, START_BLOCK_COUNT, blockCount);
        if (mxb.isThreadContentionMonitoringEnabled()) {
            long waitTime = threadInfo.getWaitedTime();
            this.setAttribute((CollectedData)servletTimerData, START_WAIT_TIME, waitTime);
            long blockTime = threadInfo.getBlockedTime();
            this.setAttribute((CollectedData)servletTimerData, START_BLOCK_TIME, blockTime);
        }
    }
}

