/*
 * Decompiled with CFR 0.152.
 */
package org.appspy.perf.servlet.skip;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appspy.perf.servlet.skip.SkipManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeSkipManager
implements SkipManager {
    protected static Log sLog = LogFactory.getLog(CompositeSkipManager.class);
    protected List<SkipManager> mSkipManagers = null;

    @Override
    public int skipRequest(ServletRequest req, ServletResponse res, ServletContext sc) {
        int skip = 2;
        for (SkipManager skipManager : this.mSkipManagers) {
            int result = skipManager.skipRequest(req, res, sc);
            if (result == 0) continue;
            skip = result;
            if (!sLog.isDebugEnabled()) break;
            if (skip == 1) {
                sLog.debug((Object)("Skipping this request because of " + skipManager));
                break;
            }
            sLog.debug((Object)("Collecting this request because of " + skipManager));
            break;
        }
        return skip;
    }

    public List<SkipManager> getSkipManagers() {
        return this.mSkipManagers;
    }

    public void setSkipManagers(List<SkipManager> skipManagers) {
        this.mSkipManagers = skipManagers;
    }
}

