/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.adapter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.arquillian.cube.openshift.impl.adapter.OpenShiftAdapter;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.proxy.Proxy;
import org.arquillian.cube.openshift.impl.resources.OpenShiftResourceHandle;
import org.arquillian.cube.openshift.impl.utils.Checker;
import org.arquillian.cube.openshift.impl.utils.Containers;
import org.arquillian.cube.openshift.impl.utils.DeploymentContext;
import org.arquillian.cube.openshift.impl.utils.Operator;
import org.arquillian.cube.openshift.impl.utils.ReflectionUtils;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.core.api.Instance;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pResponse;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class AbstractOpenShiftAdapter
implements OpenShiftAdapter {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    protected final CubeOpenShiftConfiguration configuration;
    private Map<String, List<OpenShiftResourceHandle>> resourcesMap = new ConcurrentHashMap<String, List<OpenShiftResourceHandle>>();
    private Proxy proxy;
    private Instance<ProtocolMetaData> pmdInstance;

    protected AbstractOpenShiftAdapter(CubeOpenShiftConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setProtocolMetaData(Instance<ProtocolMetaData> pmd) {
        this.pmdInstance = pmd;
    }

    protected abstract Proxy createProxy();

    public String url(String podName, int port, String path, String parameters) {
        return this.getProxy().url(podName, port, path, parameters);
    }

    public InputStream execute(String podName, int port, String path) throws Exception {
        return this.getProxy().post(podName, port, path);
    }

    public InputStream execute(int pod, int port, String path) throws Exception {
        ProtocolMetaData pmd = (ProtocolMetaData)this.pmdInstance.get();
        if (pmd != null) {
            Map<String, String> labels = DeploymentContext.getDeploymentContext(pmd).getLabels();
            return this.execute(labels, pod, port, path);
        }
        throw new IllegalStateException("No ProtocolMetaData set!");
    }

    public InputStream execute(Map<String, String> labels, int pod, int port, String path) throws Exception {
        return this.getProxy().post(labels, pod, port, path);
    }

    @Override
    public synchronized Proxy getProxy() {
        if (this.proxy == null) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    private void addResourceHandle(String resourcesKey, OpenShiftResourceHandle handle) {
        List<OpenShiftResourceHandle> list = this.resourcesMap.get(resourcesKey);
        if (list == null) {
            list = new ArrayList<OpenShiftResourceHandle>();
            this.resourcesMap.put(resourcesKey, list);
        }
        list.add(handle);
    }

    protected abstract OpenShiftResourceHandle createResourceFromStream(InputStream var1) throws IOException;

    @Override
    public Object createResource(String resourcesKey, InputStream stream) throws IOException {
        OpenShiftResourceHandle resourceHandle = this.createResourceFromStream(stream);
        this.addResourceHandle(resourcesKey, resourceHandle);
        return resourceHandle;
    }

    @Override
    public Object deleteResources(String resourcesKey) {
        List<OpenShiftResourceHandle> list = this.resourcesMap.remove(resourcesKey);
        if (list != null) {
            for (OpenShiftResourceHandle resource : list) {
                resource.delete();
            }
        }
        return list;
    }

    protected abstract OpenShiftResourceHandle createRoleBinding(String var1, String var2);

    @Override
    public Object addRoleBinding(String resourcesKey, String roleRefName, String userName) {
        OpenShiftResourceHandle handle = this.createRoleBinding(roleRefName, userName);
        this.addResourceHandle(resourcesKey, handle);
        return handle;
    }

    protected abstract Map<String, String> getLabels(String var1) throws Exception;

    public void waitForReadyPods(String prefix, int replicas) throws Exception {
        Map<String, String> labels = this.getLabels(prefix);
        Containers.delay(this.configuration.getStartupTimeout(), 4000L, new PodCountChecker(labels, Operator.EQUAL, replicas));
    }

    public void replacePods(String prefix, int size, int replicas) throws Exception {
        Map<String, String> labels = this.getLabels(prefix);
        final HashSet<String> deleted = new HashSet<String>();
        for (String pod : this.getProxy().getReadyPods(labels)) {
            if (size <= 0) break;
            deleted.add(pod);
            this.deletePod(pod, -1L);
            --size;
        }
        Containers.delay(this.configuration.getStartupTimeout(), 4000L, new PodCountChecker(labels, Operator.EQUAL, replicas){

            @Override
            protected Set<String> getReadyPods() {
                Set<String> pods = super.getReadyPods();
                pods.removeAll(deleted);
                return pods;
            }
        });
    }

    public Set<String> getReadyPods(String prefix) throws Exception {
        return this.getProxy().getReadyPods(this.getLabels(prefix));
    }

    public List<String> getPods() throws Exception {
        return this.getPods(null);
    }

    @Override
    public void delay(Map<String, String> labels, int replicas, Operator op) throws Exception {
        Containers.delay(this.configuration.getStartupTimeout(), 4000L, new PodCountChecker(labels, op, replicas));
    }

    public <T> T jolokia(Class<T> expectedReturnType, String podName, Object input) throws Exception {
        JSONAware parseResult;
        if (!(input instanceof J4pRequest)) {
            throw new IllegalArgumentException("Input must be a J4pRequest instance!");
        }
        Proxy proxy = this.getProxy();
        String url = proxy.url(podName, "https", 8778, "/jolokia/", null);
        this.log.info(String.format("Jolokia URL: %s", url));
        J4pRequest request = (J4pRequest)input;
        JSONObject jsonObject = ReflectionUtils.invoke(J4pRequest.class, "toJson", new Class[0], request, new Object[0], JSONObject.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter out = new OutputStreamWriter(baos);){
            jsonObject.writeJSONString((Writer)out);
            out.flush();
        }
        byte[] bytes = baos.toByteArray();
        baos.reset();
        try (InputStream stream = proxy.post(url, "application/json", bytes);){
            int numRead;
            byte[] buffer = new byte[512];
            while ((numRead = stream.read(buffer, 0, buffer.length)) >= 0) {
                baos.write(buffer, 0, numRead);
            }
        }
        String content = baos.toString();
        JSONParser parser = new JSONParser();
        try {
            parseResult = (JSONAware)parser.parse(content);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid Jolokia response: " + content);
        }
        if (!(parseResult instanceof JSONObject)) {
            throw new IllegalStateException("Invalid JSON answer for a single request (expected a map but got a " + parseResult.getClass() + ")");
        }
        J4pResponse response = ReflectionUtils.invoke(J4pRequest.class, "createResponse", new Class[]{JSONObject.class}, request, new Object[]{parseResult}, J4pResponse.class);
        return expectedReturnType.cast(response.getValue());
    }

    private class PodCountChecker
    implements Checker {
        private final Map<String, String> labels;
        private final Operator op;
        private final int replicas;

        public PodCountChecker(Map<String, String> labels, Operator op, int replicas) {
            this.labels = labels;
            this.op = op;
            this.replicas = replicas;
        }

        @Override
        public boolean check() {
            Set<String> pods = this.getReadyPods();
            boolean result = this.op.op(pods.size(), this.replicas);
            if (result) {
                AbstractOpenShiftAdapter.this.log.info(String.format("Condition satisfied: number of pod(s) matching labels: %s is %s %s (pods: %s)", new Object[]{this.labels, this.op, this.replicas, pods}));
            }
            return result;
        }

        protected Set<String> getReadyPods() {
            return AbstractOpenShiftAdapter.this.getProxy().getReadyPods(this.labels);
        }

        public String toString() {
            return String.format("Number of pod(s) matching labels: %s is %s %s", new Object[]{this.labels, this.op, this.replicas});
        }
    }
}

