/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.kubernetes.impl.resolver.ResourceResolver;
import org.arquillian.cube.openshift.api.Replicas;
import org.arquillian.cube.openshift.api.Template;
import org.arquillian.cube.openshift.api.TemplateParameter;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.utils.ParamValue;
import org.arquillian.cube.openshift.impl.utils.StringResolver;
import org.arquillian.cube.openshift.impl.utils.Strings;

public class TemplateUtils {
    public static void addParameterValues(List<ParamValue> values, Map map, boolean filter) {
        Set entries = map.entrySet();
        for (Map.Entry env : entries) {
            if (!(env.getKey() instanceof String) || !(env.getValue() instanceof String)) continue;
            String key = (String)env.getKey();
            if (filter && !key.startsWith("ARQ_") && !key.startsWith("arq_")) continue;
            if (filter) {
                values.add(new ParamValue(key.substring("ARQ_".length()), (String)env.getValue()));
                continue;
            }
            values.add(new ParamValue(key, (String)env.getValue()));
        }
    }

    public static String readTemplateUrl(Template template, CubeOpenShiftConfiguration configuration, boolean required, StringResolver resolver) {
        String templateUrl;
        String string = templateUrl = template == null ? null : template.url();
        if (templateUrl == null || templateUrl.length() == 0) {
            templateUrl = configuration.getTemplateURL();
        }
        if (templateUrl == null && required) {
            throw new IllegalArgumentException("Missing template URL! Either add @Template to your test or add -Dopenshift.template.url=<url>");
        }
        if (templateUrl != null) {
            String url = resolver.resolve(templateUrl);
            templateUrl = ResourceResolver.resolve((String)url).toString();
        }
        return templateUrl;
    }

    public static <T> int readReplicas(T type) {
        Replicas replicas = null;
        if (type instanceof Method) {
            replicas = ((Method)type).getAnnotation(Replicas.class);
        } else if (type instanceof Class) {
            replicas = ((Class)type).getAnnotation(Replicas.class);
        }
        int r = 1;
        if (replicas != null) {
            if (replicas.value() <= 0) {
                throw new IllegalArgumentException("Non-positive replicas size: " + replicas.value());
            }
            r = replicas.value();
        }
        return r;
    }

    public static Map<String, String> readLabels(Template template, CubeOpenShiftConfiguration configuration, StringResolver resolver) {
        String string;
        if (template != null && (string = template.labels()) != null && string.length() > 0) {
            Map<String, String> map = Strings.splitKeyValueList(string);
            HashMap<String, String> resolved = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                resolved.put(resolver.resolve(entry.getKey()), resolver.resolve(entry.getValue()));
            }
            return resolved;
        }
        return configuration.getTemplateLabelsAsMap();
    }

    public static boolean executeProcessTemplate(Template template, CubeOpenShiftConfiguration configuration) {
        return (template == null || template.process()) && configuration.isTemplateProcess();
    }

    public static Map<String, String> readParameters(Template template, CubeOpenShiftConfiguration configuration, StringResolver resolver) {
        if (template != null) {
            TemplateParameter[] parameters = template.parameters();
            HashMap<String, String> map = new HashMap<String, String>();
            for (TemplateParameter parameter : parameters) {
                String name = resolver.resolve(parameter.name());
                String value = resolver.resolve(parameter.value());
                map.put(name, value);
            }
            return map;
        }
        return configuration.getTemplateParametersAsMap();
    }
}

