/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.utils;

import java.util.Collections;
import java.util.Map;
import org.arquillian.cube.openshift.impl.proxy.Proxy;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;

public class DeploymentContext {
    private static final String DEPLOYMENT_ARCHIVE_NAME_KEY = "deploymentArchiveName";
    private final Archive<?> archive;
    private Map<String, String> labels;
    private Proxy proxy;

    public DeploymentContext(Archive<?> archive, Map<String, String> labels, Proxy proxy) {
        this.archive = archive;
        this.labels = labels;
        this.proxy = proxy;
    }

    public static DeploymentContext getDeploymentContext(ProtocolMetaData pmd) {
        return (DeploymentContext)pmd.getContexts(DeploymentContext.class).iterator().next();
    }

    public static Map<String, String> getDeploymentLabels(Archive<?> archive) {
        return Collections.singletonMap(DEPLOYMENT_ARCHIVE_NAME_KEY, archive.getName());
    }

    public Archive<?> getArchive() {
        return this.archive;
    }

    public Map<String, String> getLabels() {
        return Collections.unmodifiableMap(this.labels);
    }

    public Proxy getProxy() {
        return this.proxy;
    }
}

