/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.utils;

import java.util.Map;
import javax.net.ssl.SSLContext;
import org.arquillian.cube.openshift.api.ManagementHandle;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.proxy.Proxy;

public class ManagementHandleImpl
implements ManagementHandle {
    private final Proxy proxy;
    private final Map<String, String> labels;
    private final CubeOpenShiftConfiguration configuration;
    private final SSLContext sslContext;

    public ManagementHandleImpl(Proxy proxy, Map<String, String> labels, CubeOpenShiftConfiguration configuration, SSLContext sslContext) {
        this.proxy = proxy;
        this.labels = labels;
        this.configuration = configuration;
        this.sslContext = sslContext;
    }

    public String getOpenShiftUsername() {
        return this.configuration.getUsername();
    }

    public String getOpenShiftPassword() {
        return this.configuration.getPassword();
    }

    public String getOAuthToken() {
        return this.configuration.getToken();
    }

    public String getManagementUrl(int port) {
        return this.proxy.url(this.labels, 0, port, "", null);
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }
}

