/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class OkHttpClientUtils {
    private static final SimpleCookieJar COOKIE_JAR = new SimpleCookieJar();

    public static void applyConnectTimeout(OkHttpClient.Builder builder, long timeout) {
        builder.connectTimeout(timeout, TimeUnit.SECONDS);
    }

    public static void applyCookieJar(OkHttpClient.Builder builder) {
        OkHttpClientUtils.COOKIE_JAR.clear();
        builder.cookieJar((CookieJar)COOKIE_JAR);
    }

    private static class SimpleCookieJar
    implements CookieJar {
        private static final String _PROXY = "/proxy";
        private Map<String, List<Cookie>> cookiesMap = new ConcurrentHashMap<String, List<Cookie>>();

        private SimpleCookieJar() {
        }

        private void clear() {
            this.cookiesMap.clear();
        }

        private static String path(HttpUrl url) {
            String path = url.encodedPath();
            int p = path.indexOf(_PROXY);
            return path.substring(p + _PROXY.length());
        }

        public synchronized void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
            this.cookiesMap.put(SimpleCookieJar.path(url), cookies);
        }

        public synchronized List<Cookie> loadForRequest(HttpUrl url) {
            String path = SimpleCookieJar.path(url);
            ArrayList list = new ArrayList();
            for (Map.Entry<String, List<Cookie>> entry : this.cookiesMap.entrySet()) {
                if (!path.startsWith(entry.getKey())) continue;
                for (Cookie cookie : entry.getValue()) {
                    list.add(cookie);
                }
            }
            return list.isEmpty() ? Collections.emptyList() : list;
        }
    }
}

