/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.arquillian.cube.openshift.impl.utils.CustomValueExpressionResolver;
import org.arquillian.cube.openshift.impl.utils.StringResolver;
import org.jboss.dmr.ValueExpression;
import org.jboss.dmr.ValueExpressionResolver;

public class Strings {
    private static String checkForNone(String value) {
        return "__none".equalsIgnoreCase(value) ? null : value;
    }

    public static String firstNonBlank(String ... values) {
        for (String value : values) {
            if (!Strings.notEmpty(value)) continue;
            return value;
        }
        return null;
    }

    public static boolean notEmpty(String text) {
        return text != null && text.length() > 0;
    }

    private static String getSystemPropertyOrEnvVar(String systemPropertyName, String envVarName, String defaultValue) {
        String answer = System.getProperty(systemPropertyName);
        if (answer != null && !answer.equals("")) {
            return Strings.checkForNone(answer);
        }
        answer = System.getenv(envVarName);
        if (answer != null) {
            return Strings.checkForNone(answer);
        }
        return Strings.checkForNone(defaultValue);
    }

    private static String convertSystemPropertyNameToEnvVar(String systemPropertyName) {
        return systemPropertyName.toUpperCase().replaceAll("[.-]", "_");
    }

    public static int parseNumber(String value) {
        char ch;
        int k = 1;
        int n = 0;
        for (int i = value.length() - 1; i >= 0 && Character.isDigit(ch = value.charAt(i)); --i) {
            n += (ch - 48) * k;
            k *= 10;
        }
        return n;
    }

    public static String toValue(String value, String defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static String getSystemPropertyOrEnvVar(String key) {
        return Strings.getSystemPropertyOrEnvVar(key, null);
    }

    public static String getSystemPropertyOrEnvVar(String key, String defaultValue) {
        return Strings.getSystemPropertyOrEnvVar(key, Strings.convertSystemPropertyNameToEnvVar(key), defaultValue);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotNullOrEmpty(String str) {
        return !Strings.isNullOrEmpty(str);
    }

    public static Map<String, String> splitKeyValueList(String string) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (string != null && string.length() > 0) {
            String[] split;
            for (String s : split = string.split(",")) {
                String[] ss = s.split("=");
                labels.put(ss[0], ss[1]);
            }
        }
        return labels;
    }

    public static StringResolver createStringResolver(Properties properties) {
        ValueExpressionResolver resolver = Strings.createValueExpressionResolver(properties);
        return value -> new ValueExpression(value).resolveString(resolver);
    }

    private static ValueExpressionResolver createValueExpressionResolver(Properties properties) {
        return new CustomValueExpressionResolver(properties);
    }
}

