/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.clnt.v2_6.Config;
import io.fabric8.kubernetes.clnt.v2_6.ConfigBuilder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.arquillian.cube.impl.util.ConfigUtil;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.kubernetes.impl.DefaultConfiguration;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfigurationBuilder;

public class CubeOpenShiftConfiguration
extends DefaultConfiguration {
    private static final Config FALLBACK_CONFIG = new ConfigBuilder().build();
    private static final String ORIGIN_SERVER = "originServer";
    private static final String KEEP_ALIVE_GIT_SERVER = "keepAliveGitServer";
    private static final String DEFINITIONS_FILE = "definitionsFile";
    private static final String DEFINITIONS = "definitions";
    private static final String ENABLE_IMAGE_STREAM_DETECTION = "enableImageStreamDetection";
    private static final String AUTO_START_CONTAINERS = "autoStartContainers";
    private static final String PROXIED_CONTAINER_PORTS = "proxiedContainerPorts";
    private static final String PORT_FORWARDER_BIND_ADDRESS = "portForwardBindAddress";
    private static final String ROUTER_HOST = "routerHost";
    private static final String OPENSHIFT_ROUTER_HTTP_PORT = "openshiftRouterHttpPort";
    private static final String OPENSHIFT_ROUTER_HTTPS_PORT = "openshiftRouterHttpsPort";
    private static final String DEFAULT_OPENSHIFT_CONFIG_FILE_NAME = "openshift.json";
    private final boolean keepAliveGitServer;
    private final String definitions;
    private final String definitionsFile;
    private final String[] autoStartContainers;
    private final Set<String> proxiedContainerPorts;
    private final String portForwardBindAddress;
    private final String routerHost;
    private final int openshiftRouterHttpPort;
    private final int openshiftRouterHttpsPort;

    public CubeOpenShiftConfiguration(String sessionId, URL masterUrl, String namespace, Map<String, String> scriptEnvironmentVariables, URL environmentSetupScriptUrl, URL environmentTeardownScriptUrl, URL environmentConfigUrl, List<URL> environmentConfigAdditionalUrls, List<URL> environmentDependencies, boolean namespaceLazyCreateEnabled, boolean namespaceCleanupEnabled, long namespaceCleanupTimeout, boolean namespaceCleanupConfirmationEnabled, boolean namespaceDestroyEnabled, long namespaceDestroyTimeout, boolean namespaceDestroyConfirmationEnabled, long waitTimeout, long waitPollInterval, List<String> waitForServiceList, boolean ansiLoggerEnabled, boolean environmentInitEnabled, boolean logCopyEnabled, String logPath, String kubernetesDomain, String dockerRegistry, boolean keepAliveGitServer, String definitions, String definitionsFile, String[] autoStartContainers, Set<String> proxiedContainerPorts, String portForwardBindAddress, String routerHost, int openshiftRouterHttpPort, int openshiftRouterHttpsPort) {
        super(sessionId, masterUrl, namespace, scriptEnvironmentVariables, environmentSetupScriptUrl, environmentTeardownScriptUrl, environmentConfigUrl, environmentConfigAdditionalUrls, environmentDependencies, namespaceLazyCreateEnabled, namespaceCleanupEnabled, namespaceCleanupTimeout, namespaceCleanupConfirmationEnabled, namespaceDestroyEnabled, namespaceDestroyConfirmationEnabled, namespaceDestroyTimeout, waitTimeout, waitPollInterval, waitForServiceList, ansiLoggerEnabled, environmentInitEnabled, logCopyEnabled, logPath, kubernetesDomain, dockerRegistry);
        this.keepAliveGitServer = keepAliveGitServer;
        this.definitions = definitions;
        this.definitionsFile = definitionsFile;
        this.autoStartContainers = autoStartContainers;
        this.proxiedContainerPorts = proxiedContainerPorts;
        this.portForwardBindAddress = portForwardBindAddress;
        this.routerHost = routerHost;
        this.openshiftRouterHttpPort = openshiftRouterHttpPort;
        this.openshiftRouterHttpsPort = openshiftRouterHttpsPort;
    }

    private static String[] split(String str, String regex) {
        if (str == null || str.isEmpty()) {
            return new String[0];
        }
        return str.split(regex);
    }

    public static CubeOpenShiftConfiguration fromMap(Map<String, String> map) {
        File[] files;
        File targetDir;
        String sessionId = UUID.randomUUID().toString().split("-")[0];
        String namespace = ConfigUtil.getBooleanProperty((String)"namespace.use.current", map, (Boolean)false) != false ? new ConfigBuilder().build().getNamespace() : ConfigUtil.getStringProperty((String)"namespace.use.existing", map, null);
        Boolean shouldDestroyNamespace = false;
        if (Strings.isNullOrEmpty((String)namespace)) {
            namespace = ConfigUtil.getStringProperty((String)"namespace.prefix", map, (String)"itest") + "-" + sessionId;
            shouldDestroyNamespace = true;
        }
        LinkedList<URL> additionalUrls = new LinkedList<URL>();
        boolean enableImageStreamDetection = ConfigUtil.getBooleanProperty((String)ENABLE_IMAGE_STREAM_DETECTION, map, (Boolean)false);
        if (enableImageStreamDetection && (targetDir = new File(System.getProperty("basedir", ".") + "/target")).exists() && targetDir.isDirectory() && (files = targetDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().endsWith("-is.yml")) continue;
                try {
                    additionalUrls.add(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        try {
            return ((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)new CubeOpenShiftConfigurationBuilder().withSessionId(sessionId)).withNamespace(namespace)).withMasterUrl(new URL(ConfigUtil.getStringProperty((String)"master.url", (String)"kubernetes.master", map, (String)FALLBACK_CLIENT_CONFIG.getMasterUrl())))).withScriptEnvironmentVariables(CubeOpenShiftConfiguration.parseMap((String)map.get("env.script.env")))).withEnvironmentInitEnabled(ConfigUtil.getBooleanProperty((String)"env.init.enabled", map, (Boolean)true))).withLogCopyEnabled(ConfigUtil.getBooleanProperty((String)"logs.copy", map, (Boolean)false))).withLogPath(ConfigUtil.getStringProperty((String)"logs.path", map, null))).withEnvironmentSetupScriptUrl(CubeOpenShiftConfiguration.asUrlOrResource((String)ConfigUtil.getStringProperty((String)"env.setup.script.url", map, null)))).withEnvironmentTeardownScriptUrl(CubeOpenShiftConfiguration.asUrlOrResource((String)ConfigUtil.getStringProperty((String)"env.teardown.script.url", map, null)))).withEnvironmentConfigUrl(CubeOpenShiftConfiguration.getKubernetesConfigurationUrl(map, (String)DEFAULT_OPENSHIFT_CONFIG_FILE_NAME))).withEnvironmentConfigAdditionalUrls(additionalUrls)).withEnvironmentDependencies(ConfigUtil.asURL((List)Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"env.dependencies", map, (String)""), (String)"\\s+")))).withNamespaceLazyCreateEnabled(ConfigUtil.getBooleanProperty((String)"namespace.lazy.enabled", map, (Boolean)DEFAULT_NAMESPACE_LAZY_CREATE_ENABLED))).withNamespaceCleanupEnabled(ConfigUtil.getBooleanProperty((String)"namespace.cleanup.enabled", map, (Boolean)true))).withNamespaceCleanupConfirmationEnabled(ConfigUtil.getBooleanProperty((String)"namespace.cleanup.confirm.enabled", map, (Boolean)false))).withNamespaceCleanupTimeout(ConfigUtil.getLongProperty((String)"namespace.cleanup.timeout", map, (Long)DEFAULT_NAMESPACE_CLEANUP_TIMEOUT))).withNamespaceDestroyEnabled(ConfigUtil.getBooleanProperty((String)"namespace.destroy.enabled", map, (Boolean)shouldDestroyNamespace))).withNamespaceDestroyConfirmationEnabled(ConfigUtil.getBooleanProperty((String)"namespace.destroy.confirm.enabled", map, (Boolean)false))).withNamespaceDestroyTimeout(ConfigUtil.getLongProperty((String)"namespace.destroy.timeout", map, (Long)DEFAULT_NAMESPACE_DESTROY_TIMEOUT))).withWaitTimeout(ConfigUtil.getLongProperty((String)"wait.timeout", map, (Long)DEFAULT_WAIT_TIMEOUT))).withWaitPollInterval(ConfigUtil.getLongProperty((String)"wait.poll.interval", map, (Long)DEFAULT_WAIT_POLL_INTERVAL))).withWaitForServiceList(Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"wait.for.service.list", map, (String)""), (String)"\\s+"))).withAnsiLoggerEnabled(ConfigUtil.getBooleanProperty((String)"ansi.logger.enabled", map, (Boolean)true))).withKubernetesDomain(ConfigUtil.getStringProperty((String)"domain", (String)"kubernetes.domain", map, null))).withDockerRegistry(CubeOpenShiftConfiguration.getDockerRegistry(map))).withKeepAliveGitServer(ConfigUtil.getBooleanProperty((String)KEEP_ALIVE_GIT_SERVER, map, (Boolean)false))).withDefinitions(ConfigUtil.getStringProperty((String)DEFINITIONS, map, null))).withDefinitionsFile(ConfigUtil.getStringProperty((String)DEFINITIONS_FILE, map, null))).withAutoStartContainers(CubeOpenShiftConfiguration.split(ConfigUtil.getStringProperty((String)AUTO_START_CONTAINERS, map, (String)""), ","))).withProxiedContainerPorts(CubeOpenShiftConfiguration.split(ConfigUtil.getStringProperty((String)PROXIED_CONTAINER_PORTS, map, (String)""), ","))).withPortForwardBindAddress(ConfigUtil.getStringProperty((String)PORT_FORWARDER_BIND_ADDRESS, map, (String)"127.0.0.1"))).withRouterHost(ConfigUtil.getStringProperty((String)ROUTER_HOST, (String)"openshift.router.host", map, null))).withOpenshiftRouterHttpPort(ConfigUtil.getIntProperty((String)OPENSHIFT_ROUTER_HTTP_PORT, Optional.of("openshift.router.httpPort"), map, (int)80))).withOpenshiftRouterHttpsPort(ConfigUtil.getIntProperty((String)OPENSHIFT_ROUTER_HTTPS_PORT, Optional.of("openshift.router.httpsPort"), map, (int)443))).build();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public String getOriginServer() {
        return this.getMasterUrl().toString();
    }

    public boolean isKeepAliveGitServer() {
        return this.keepAliveGitServer;
    }

    public String getDefinitionsFile() {
        return this.definitionsFile;
    }

    public String getDefinitions() {
        return this.definitions;
    }

    public boolean shouldKeepAliveGitServer() {
        return this.keepAliveGitServer;
    }

    public String[] getAutoStartContainers() {
        if (this.autoStartContainers == null) {
            return new String[0];
        }
        return this.autoStartContainers;
    }

    public Set<String> getProxiedContainerPorts() {
        if (this.proxiedContainerPorts == null) {
            return Collections.emptySet();
        }
        return this.proxiedContainerPorts;
    }

    public String getPortForwardBindAddress() {
        return this.portForwardBindAddress;
    }

    public String getRouterHost() {
        return this.routerHost;
    }

    public int getOpenshiftRouterHttpPort() {
        return this.openshiftRouterHttpPort;
    }

    public int getOpenshiftRouterHttpsPort() {
        return this.openshiftRouterHttpsPort;
    }
}

