/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.enricher;

import io.fabric8.kubernetes.clnt.v2_6.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v2_6.dsl.Resource;
import io.fabric8.openshift.api.model.v2_6.Route;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.arquillian.cube.impl.util.ReflectionUtil;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.arquillian.cube.openshift.impl.enricher.RouteURL;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestEnricher;

public class RouteURLEnricher
implements TestEnricher {
    @Inject
    private Instance<OpenShiftClient> clientInstance;
    @Inject
    private Instance<Configuration> configurationInstance;

    public void enrich(Object testCase) {
        for (Field field : ReflectionUtil.getFieldsWithAnnotation(testCase.getClass(), RouteURL.class)) {
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(testCase, this.lookup(this.getRouteURLAnnotation(field.getAnnotations())));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set RouteURL value on field " + field, e);
            }
        }
    }

    public Object[] resolve(Method method) {
        Object[] values = new Object[method.getParameterTypes().length];
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            RouteURL routeURL = this.getRouteURLAnnotation(method.getParameterAnnotations()[i]);
            if (routeURL == null) continue;
            values[i] = this.lookup(routeURL);
        }
        return values;
    }

    private RouteURL getRouteURLAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != RouteURL.class) continue;
            return (RouteURL)annotation;
        }
        return null;
    }

    private URL lookup(RouteURL routeURL) {
        String routeName = routeURL.value();
        if (routeURL == null || routeName == null || routeName.length() == 0) {
            throw new NullPointerException("RouteURL is null, must specify a route name!");
        }
        CubeOpenShiftConfiguration config = (CubeOpenShiftConfiguration)((Object)this.configurationInstance.get());
        if (config == null) {
            throw new NullPointerException("CubeOpenShiftConfiguration is null.");
        }
        OpenShiftClient client = (OpenShiftClient)this.clientInstance.get();
        Route route = (Route)((Resource)((NonNamespaceOperation)client.getClient().routes().inNamespace(config.getNamespace())).withName(routeName)).get();
        if (route == null) {
            throw new IllegalArgumentException("Could not resolve route: " + routeName);
        }
        String protocol = route.getSpec().getTls() == null ? "http" : "https";
        int port = protocol.equals("http") ? config.getOpenshiftRouterHttpPort() : config.getOpenshiftRouterHttpsPort();
        try {
            return new URL(protocol, route.getSpec().getHost(), port, "/");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to create route URL", e);
        }
    }
}

